<?php
if (!defined('ABSPATH') || !is_admin() || !current_user_can('manage_options')) {
   die;
}
?>
<div class="wfs-main">
   <div class="wfs-heading form sticky-top">
      <ul>
         <li class="<?= $current_tab == 'keywords' ? 'active' : ''; ?>">
            <a href="admin.php?page=wfs-search-logs&tab=keywords"><?php _e('Searched words', 'webafra-fara-search'); ?></a>
         </li>
         <li class="<?= $current_tab == 'logs' ? 'active' : ''; ?>">
            <a href="admin.php?page=wfs-search-logs&tab=logs"><?php _e('Search logs', 'webafra-fara-search'); ?></a>
         </li>
      </ul>
      <div style="display:flex;gap:1rem;">
         <?php if ($current_tab == 'keywords') : ?>
            <button type="button" class="wfs-button svg-medium green" onclick="wac_change_css_displaying('#wfs-search-keyword-help');">
               <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                  <circle cx="12" cy="12" r="10"></circle>
                  <path d="M9.09 9a3 3 0 0 1 5.83 1c0 2-3 3-3 3"></path>
                  <line x1="12" y1="17" x2="12.01" y2="17"></line>
               </svg>
               <?php _e('Help', 'webafra-fara-search'); ?>
            </button>
            <button type="button" class="wfs-button svg-medium" onclick="wac_change_css_displaying('#wfs-search-keyword-new');">
               <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                  <path d="M3 3h18v18H3zM12 8v8m-4-4h8" />
               </svg>
               <?php _e('Add new keyword', 'webafra-fara-search'); ?>
            </button>
         <?php endif; ?>
      </div>
   </div>
   <div class="wfs-content">
      <?php if (!empty($this->error)) : ?>
         <div class="wfs-alert danger"><?= $this->error; ?></div>
      <?php endif; ?>
      <?php if ($current_tab == 'logs') : ?>
         <?php if (!is_null($search_logs->data) && count($search_logs->data)) : ?>
            <?php foreach ($search_logs->data as $search_log) : ?>
               <form action="<?= $this->request_uri; ?>" method="POST">
                  <div class="wfs-popup-overlay" id="wfs-search-log-delete-<?= $search_log->id; ?>">
                     <div class="wfs-popup">
                        <input type="hidden" name="wfs_search_log_delete_id" value="<?= $search_log->id; ?>" />
                        <div class="heading header">
                           <h3><?php _e('Delete log', 'webafra-fara-search'); ?> <span class="heading-badge"><?php _e('Id', 'webafra-fara-search'); ?>: #<?= $search_log->id; ?></span>
                           </h3>
                           <a class="close-btn" onclick="wac_change_css_displaying('#wfs-search-log-delete-<?= $search_log->id; ?>', 'none');" href="javascript:void(0);">
                              <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="butt" stroke-linejoin="arcs">
                                 <line x1="18" y1="6" x2="6" y2="18"></line>
                                 <line x1="6" y1="6" x2="18" y2="18"></line>
                              </svg>
                           </a>
                        </div>
                        <div class="wfs-popup-content">
                           <p><?php _e('Delete search log permanently.', 'webafra-fara-search'); ?></p>
                        </div>
                        <div class="heading footer">
                           <div></div>
                           <div style="display:flex;flex-direction:row;gap:.5rem;">
                              <button type="submit" name="wfs_search_log_delete_submit" class="wfs-button danger svg-medium">
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="3 6 5 6 21 6"></polyline>
                                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                    <line x1="10" y1="11" x2="10" y2="17"></line>
                                    <line x1="14" y1="11" x2="14" y2="17"></line>
                                 </svg>
                                 <?php _e('Delete', 'webafra-fara-search'); ?>
                              </button>
                           </div>
                        </div>
                     </div>
                  </div>
               </form>
            <?php endforeach; ?>
         <?php endif;
         ?>
         <form action="" method="POST" class="form-inputs">
            <div class="content-controls">
               <div class="controls-right">
                  <select name="bulk_action" id="bulk_action" class="dropdown">
                     <option value="-1" selected="selected"><?= __('Bulk actions', 'webafra-fara-search'); ?></option>
                     <option value="delete_selected"><?= __('Delete selected', 'webafra-fara-search'); ?></option>
                  </select>
                  <input type="submit" name="wf_bulk_action" class="button" value="<?= __('Do action', 'webafra-fara-search'); ?>">

                  <div style="width:100%;">
                     <select name="filter_by" id="filter_by" class="dropdown">
                        <option value=""><?= __('Select', 'webafra-fara-search'); ?>...</option>
                        <option value="has_result" <?= isset($_GET['filter_by']) && $_GET['filter_by'] == 'has_result' ? 'selected="selected"' : ''; ?>><?= __('Has result', 'webafra-fara-search'); ?></option>
                        <option value="has_no_result" <?= isset($_GET['filter_by']) && $_GET['filter_by'] == 'has_no_result' ? 'selected="selected"' : ''; ?>><?= __('Has no result', 'webafra-fara-search'); ?></option>
                     </select>

                     <select name="filter_by_form" id="filter_by_form" class="dropdown">
                        <option value=""><?= __('Select form', 'webafra-fara-search'); ?>...</option>
                        <?php if (!empty($forms_raw)) : ?>
                           <?php foreach ($forms_raw as $form) : ?>
                              <option value="<?= $form->id; ?>" <?= isset($_GET['filter_by_form']) && $_GET['filter_by_form'] == $form->id ? 'selected="selected"' : ''; ?>><?= $form->title; ?></option>
                           <?php endforeach; ?>
                        <?php endif; ?>
                     </select>

                     <input type="search" name="search" value="<?= isset($_GET['search']) ? $_GET['search'] : ''; ?>" placeholder="<?= __('Search', 'webafra-fara-search'); ?>..." style="width:150px;">

                     <?php
                     $filter_date_template = wfs_PP . '/templates/admin/filter-by-created-at.php';

                     if (file_exists($filter_date_template)) {
                        include $filter_date_template;
                     }
                     ?>

                     <input type="submit" name="filter_action" class="button" value="<?= __('Filter', 'webafra-fara-search'); ?>">
                  </div>
               </div>
               <div class="controls-left">
                  <div><?= $search_logs->total_item; ?> <?php _e('item', 'webafra-fara-search'); ?></div>
                  <div class="per-pages">
                     <div><?php _e('Show', 'webafra-fara-search'); ?>: </div>
                     <select name="per_pages_top" id="per_pages_top" class="dropdown">
                        <?php foreach ($this->per_pages_items as $per_pages_item) : ?>
                           <option value="<?= $per_pages_item; ?>" <?= isset($args['per_pages']) && $args['per_pages'] == $per_pages_item ? 'selected' : ''; ?>><?= $per_pages_item; ?></option>
                        <?php endforeach; ?>
                     </select>
                     <input type="submit" name="per_pages_top_action" class="button" value="<?= __('Change', 'webafra-fara-search'); ?>">
                  </div>
               </div>
            </div>
            <table class="wfs-table">
               <thead>
                  <tr>
                     <th scope="col">
                        <input type="checkbox" onchange="wac_tables_check_all(this, '<?= !is_null($search_logs->data) && count($search_logs->data) ? count($search_logs->data) : 0; ?>')" value="">
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'text' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=text&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('Word', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'text' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th scope="col">
                        <?php _e('Form id', 'webafra-fara-search'); ?>
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'user_id' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=user_id&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('User', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'user_id' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'has_result' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=has_result&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('Has result', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'has_result' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'created_at' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=created_at&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('Created at', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'created_at' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th><?php _e('Action', 'webafra-fara-search'); ?></th>
                  </tr>
               </thead>
               <tbody>
                  <?php if (!is_null($search_logs->data) && count($search_logs->data)) : ?>
                     <?php $bulk_tmp_index = 0; ?>
                     <?php foreach ($search_logs->data as $search_log) : $form_data = WFS_DB_Queries::get_form($search_log->form_id); ?>
                        <tr>
                           <td>
                              <input type="checkbox" name="bulk_items[]" id="bulk_items_checkbox_<?= $bulk_tmp_index; ?>" value="<?= $search_log->id; ?>">
                           </td>
                           <td scope="col"><?= $search_log->text; ?></td>
                           <td scope="col"><?= $form_data ? $form_data->title : $search_log->form_id; ?></td>
                           <td scope="col">
                              <?php if ($search_log->user_id) : ?>
                                 <?= wfs_user_display_name($search_log->user_id); ?>
                              <?php else : ?>
                                 -
                              <?php endif; ?>
                           </td>
                           <td scope="col">
                              <?php if ($search_log->has_result) : ?>
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#559a00" stroke-width="4" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                 </svg>
                              <?php else : ?>
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#d0021b" stroke-width="4" stroke-linecap="round" stroke-linejoin="round">
                                    <line x1="18" y1="6" x2="6" y2="18"></line>
                                    <line x1="6" y1="6" x2="18" y2="18"></line>
                                 </svg>
                              <?php endif; ?>
                           </td>
                           <td scope="col">
                              <?php if ($search_log->created_at) : ?>
                                 <span class="wfs-date"><?= wac_date($search_log->created_at, get_option('wff_settings_date_calendar', 'gregorian_calendar'), 'Y-m-d H:i:s'); ?></span>
                              <?php else : ?>
                                 -
                              <?php endif; ?>
                           </td>
                           <td>
                              <ul class="wfs-action-options icon-action">
                                 <li>
                                    <a title="<?php _e('Delete log', 'webafra-fara-search'); ?>" href="javascript:void(0);" onclick="wac_change_css_displaying('#wfs-search-log-delete-<?= $search_log->id; ?>');">
                                       <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                          <polyline points="3 6 5 6 21 6"></polyline>
                                          <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                          <line x1="10" y1="11" x2="10" y2="17"></line>
                                          <line x1="14" y1="11" x2="14" y2="17"></line>
                                       </svg>
                                    </a>
                                 </li>
                              </ul>
                           </td>
                        </tr>
                        <?php $bulk_tmp_index++; ?>
                     <?php endforeach; ?>
                  <?php else : ?>
                     <tr>
                        <td colspan="6" style="text-align:center;"><?php _e('No item found.', 'webafra-fara-search'); ?></td>
                     </tr>
                  <?php endif; ?>
               </tbody>
            </table>
            <div class="content-controls">
               <div class="controls-right">
                  <?php if (!is_null($search_logs->total_page) && !empty($search_logs->total_page) && $search_logs->total_page > 1) : ?>
                     <?= wac_pagination(intval($search_logs->total_page)); ?>
                  <?php endif; ?>
               </div>
               <div class="controls-left">
                  <div><?= $search_logs->total_item; ?> <?php _e('item', 'webafra-fara-search'); ?></div>
                  <div class="per-pages">
                     <div><?php _e('Show', 'webafra-fara-search'); ?>: </div>
                     <select name="per_pages_bottom" id="per_pages_bottom" class="dropdown">
                        <?php foreach ($this->per_pages_items as $per_pages_item) : ?>
                           <option value="<?= $per_pages_item; ?>" <?= isset($args['per_pages']) && $args['per_pages'] == $per_pages_item ? 'selected' : ''; ?>><?= $per_pages_item; ?></option>
                        <?php endforeach; ?>
                     </select>
                     <input type="submit" name="per_pages_bottom_action" class="button" value="<?= __('Change', 'webafra-fara-search'); ?>">
                  </div>
               </div>
            </div>
         </form>
      <?php elseif ($current_tab == 'keywords') : ?>
         <div class="wfs-popup-overlay" id="wfs-search-keyword-help" style="display: <?= !get_option('wfs_search_logs_keywords_help_popup') ? 'flex' : 'none'; ?>">
            <?php
            // Update help popup.
            if (!get_option('wfs_search_logs_keywords_help_popup')) {
               update_option('wfs_search_logs_keywords_help_popup', time());
            }
            ?>
            <div class="wfs-popup">
               <div class="heading header">
                  <h3><?php _e('Help', 'webafra-fara-search'); ?></h3>
                  <a class="close-btn" onclick="wac_change_css_displaying('#wfs-search-keyword-help', 'none');" href="javascript:void(0);">
                     <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="butt" stroke-linejoin="arcs">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                     </svg>
                  </a>
               </div>
               <div class="wfs-popup-content">
                  <div class="wfs-alert">
                     <p style="margin-bottom:10px;"><strong><?= __('is Special', 'webafra-fara-search'); ?></strong>: <?= __('Keywords in related results are displayed at the top of the results.', 'webafra-fara-search'); ?></p>
                     <p style="margin-bottom:10px;"><strong><?= __('is Ignored', 'webafra-fara-search'); ?></strong>: <?= __('Block words to prevent them from appearing in related word results, user history, and hot searches.', 'webafra-fara-search'); ?></p>
                     <p><strong><?= __('Period hot count', 'webafra-fara-search'); ?></strong>: <?= __('Display the number of times searched in the selected date range for hot searches related to each word.', 'webafra-fara-search'); ?></p>
                  </div>
               </div>
            </div>
         </div>
         <?php if (isset($_GET['filter_by_form']) && is_numeric($_GET['filter_by_form'])) : ?>
            <?php $top_search_texts_daily_for_chart = $this->get_top_search_texts_daily_for_chart((int) $_GET['filter_by_form']); ?>
            <div class="wfs-keywords-chart">
               <canvas id="wfs-keywords-chart-box" style="width:100%;height:200px;"></canvas>
               <script src="<?= wfs_PF; ?>assets/js/chart.js"></script>
               <script type="text/javascript">
                  new Chart(document.getElementById('wfs-keywords-chart-box'), {
                     type: 'line',
                     data: {
                        datasets: <?= wp_json_encode($top_search_texts_daily_for_chart); ?>,
                        fill: true,
                     },
                     options: {
                        responsive: false,
                        plugins: {
                           legend: {
                              position: 'top',
                              labels: {
                                 color: "#000000",
                                 font: {
                                    size: 12,
                                    family: "'iranyekan-regular', Arial, sans-serif",
                                 }
                              }
                           },
                        },
                        scales: {
                           x: {
                              ticks: {
                                 font: {
                                    size: 12,
                                    family: "'iranyekan-regular', Arial, sans-serif",
                                 },
                              },
                           },
                           y: {
                              ticks: {
                                 font: {
                                    size: 12,
                                    family: "'iranyekan-regular', Arial, sans-serif",
                                 },
                              },
                           }
                        }
                     },
                  });
               </script>
            </div>
         <?php endif; ?>
         <form action="<?= $this->request_uri; ?>" method="POST">
            <div class="wfs-popup-overlay" id="wfs-search-keyword-new">
               <div class="wfs-popup">
                  <div class="heading header">
                     <h3><?php _e('New word', 'webafra-fara-search'); ?></h3>
                     <a class="close-btn" onclick="wac_change_css_displaying('#wfs-search-keyword-new', 'none');" href="javascript:void(0);">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="butt" stroke-linejoin="arcs">
                           <line x1="18" y1="6" x2="6" y2="18"></line>
                           <line x1="6" y1="6" x2="18" y2="18"></line>
                        </svg>
                     </a>
                  </div>
                  <div class="wfs-popup-content">
                     <div class="wfs-rows gap-medium">
                        <div class="wfs-columns w-49">
                           <label class="mb-10" for="text"><?php _e('Word', 'webafra-fara-search'); ?></label>
                           <input type="text" class="wfs-input w-100" id="text" name="text" value="" required />
                        </div>
                        <div class="wfs-columns w-49">
                           <label class="mb-10" for="form"><?php _e('Form', 'webafra-fara-search'); ?></label>
                           <select id="form" name="form_id" class="wfs-input wfs-select w-100" required>
                              <?php if (!empty($forms_raw)) : ?>
                                 <?php foreach ($forms_raw as $form) : ?>
                                    <option value="<?= $form->id; ?>"><?= $form->title; ?></option>
                                 <?php endforeach; ?>
                              <?php endif; ?>
                           </select>
                        </div>
                     </div>
                     <div class="wfs-rows gap-medium nbb">
                        <div class="wfs-columns w-49">
                           <div class="wfs-rows nbb">
                              <div class="wfs-columns w-49">
                                 <label for="is_special"><?php _e('is Special', 'webafra-fara-search'); ?></label>
                              </div>
                              <div class="wfs-columns">
                                 <input type="checkbox" id="is_special" class="wfs-input ui-toggle" name="is_special" value="1" />
                              </div>
                           </div>
                        </div>
                        <div class="wfs-columns w-49">
                           <div class="wfs-rows nbb">
                              <div class="wfs-columns w-49">
                                 <label for="is_ignored"><?php _e('is Ignored', 'webafra-fara-search'); ?></label>
                              </div>
                              <div class="wfs-columns">
                                 <input type="checkbox" id="is_ignored" class="wfs-input ui-toggle" name="is_ignored" value="1" />
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="heading footer">
                     <div></div>
                     <div style="display:flex;flex-direction:row;gap:.5rem;">
                        <button type="submit" name="wfs_search_keyword_new_submit" class="wfs-button svg-medium">
                           <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                              <path d="M3 3h18v18H3zM12 8v8m-4-4h8" />
                           </svg>
                           <?php _e('Add', 'webafra-fara-search'); ?>
                        </button>
                     </div>
                  </div>
               </div>
            </div>
         </form>
         <?php if (!is_null($search_keywords->data) && count($search_keywords->data)) : ?>
            <?php foreach ($search_keywords->data as $search_keyword) : ?>
               <form action="<?= $this->request_uri; ?>" method="POST">
                  <div class="wfs-popup-overlay" id="wfs-search-keyword-delete-<?= $search_keyword->id; ?>">
                     <div class="wfs-popup">
                        <input type="hidden" name="wfs_search_keyword_delete_id" value="<?= $search_keyword->id; ?>" />
                        <div class="heading header">
                           <h3><?php _e('Delete keyword', 'webafra-fara-search'); ?> <span class="heading-badge"><?php _e('Id', 'webafra-fara-search'); ?>: #<?= $search_keyword->id; ?></span>
                           </h3>
                           <a class="close-btn" onclick="wac_change_css_displaying('#wfs-search-keyword-delete-<?= $search_keyword->id; ?>', 'none');" href="javascript:void(0);">
                              <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="butt" stroke-linejoin="arcs">
                                 <line x1="18" y1="6" x2="6" y2="18"></line>
                                 <line x1="6" y1="6" x2="18" y2="18"></line>
                              </svg>
                           </a>
                        </div>
                        <div class="wfs-popup-content">
                           <p><?php _e('Delete search keyword permanently.', 'webafra-fara-search'); ?></p>
                        </div>
                        <div class="heading footer">
                           <div></div>
                           <div style="display:flex;flex-direction:row;gap:.5rem;">
                              <button type="submit" name="wfs_search_keyword_delete_submit" class="wfs-button danger svg-medium">
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="3 6 5 6 21 6"></polyline>
                                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                    <line x1="10" y1="11" x2="10" y2="17"></line>
                                    <line x1="14" y1="11" x2="14" y2="17"></line>
                                 </svg>
                                 <?php _e('Delete', 'webafra-fara-search'); ?>
                              </button>
                           </div>
                        </div>
                     </div>
                  </div>

                  <div class="wfs-popup-overlay" id="wfs-search-keyword-edit-<?= $search_keyword->id; ?>">
                     <div class="wfs-popup">
                        <input type="hidden" name="wfs_search_keyword_edit_id" value="<?= $search_keyword->id; ?>" />
                        <div class="heading header">
                           <h3><?php _e('Edit keyword', 'webafra-fara-search'); ?> <span class="heading-badge"><?php _e('Id', 'webafra-fara-search'); ?>: #<?= $search_keyword->id; ?></span>
                           </h3>
                           <a class="close-btn" onclick="wac_change_css_displaying('#wfs-search-keyword-edit-<?= $search_keyword->id; ?>', 'none');" href="javascript:void(0);">
                              <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="butt" stroke-linejoin="arcs">
                                 <line x1="18" y1="6" x2="6" y2="18"></line>
                                 <line x1="6" y1="6" x2="18" y2="18"></line>
                              </svg>
                           </a>
                        </div>
                        <div class="wfs-popup-content height-limit">
                           <div class="wfs-rows gap-medium">
                              <div class="wfs-columns w-49">
                                 <label class="mb-10" for="text"><?php _e('Word', 'webafra-fara-search'); ?></label>
                                 <input type="text" class="wfs-input w-100" id="text" name="text" value="<?= $search_keyword->text; ?>" required />
                              </div>
                              <div class="wfs-columns w-49">
                                 <label class="mb-10" for="form"><?php _e('Form', 'webafra-fara-search'); ?></label>
                                 <select id="form" name="form_id" class="wfs-input wfs-select w-100" required>
                                    <?php if (!empty($forms_raw)) : ?>
                                       <?php foreach ($forms_raw as $form) : ?>
                                          <option value="<?= $form->id; ?>" <?= $search_keyword->form_id == $form->id ? 'selected' : ''; ?>><?= $form->title; ?></option>
                                       <?php endforeach; ?>
                                    <?php endif; ?>
                                 </select>
                              </div>
                           </div>
                           <div class="wfs-rows gap-medium">
                              <div class="wfs-columns w-49">
                                 <div class="wfs-rows nbb">
                                    <div class="wfs-columns w-49">
                                       <label for="is_special"><?php _e('is Special', 'webafra-fara-search'); ?></label>
                                    </div>
                                    <div class="wfs-columns">
                                       <input type="checkbox" id="is_special" class="wfs-input ui-toggle" name="is_special" value="1" <?= $search_keyword->is_special ? 'checked' : ''; ?> />
                                    </div>
                                 </div>
                              </div>
                              <div class="wfs-columns w-49">
                                 <div class="wfs-rows nbb">
                                    <div class="wfs-columns w-49">
                                       <label for="is_ignored"><?php _e('is Ignored', 'webafra-fara-search'); ?></label>
                                    </div>
                                    <div class="wfs-columns">
                                       <input type="checkbox" id="is_ignored" class="wfs-input ui-toggle" name="is_ignored" value="1" <?= $search_keyword->is_ignored ? 'checked' : ''; ?> />
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <div class="wfs-rows gap-medium nbb">
                              <div class="wfs-columns w-49">
                                 <label class="mb-10" for="count"><?php _e('Count', 'webafra-fara-search'); ?></label>
                                 <input type="number" class="wfs-input ltr w-100" id="count" name="count" value="<?= $search_keyword->count; ?>" />
                              </div>
                           </div>
                        </div>
                        <div class="heading footer">
                           <div></div>
                           <div style="display:flex;flex-direction:row;gap:.5rem;">
                              <button type="submit" name="wfs_search_keyword_edit_submit" class="wfs-button svg-medium">
                                 <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <path d="M20 14.66V20a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h5.34"></path>
                                    <polygon points="18 2 22 6 12 16 8 16 8 12 18 2"></polygon>
                                 </svg>
                                 <?php _e('Edit', 'webafra-fara-search'); ?>
                              </button>
                           </div>
                        </div>
                     </div>
                  </div>
               </form>
            <?php endforeach; ?>
         <?php endif;
         ?>
         <form action="" method="POST" class="form-inputs">
            <div class="content-controls">
               <div class="controls-right">
                  <select name="bulk_action" id="bulk_action" class="dropdown">
                     <option value="-1" selected="selected"><?= __('Bulk actions', 'webafra-fara-search'); ?></option>
                     <option value="delete_selected"><?= __('Delete selected', 'webafra-fara-search'); ?></option>
                     <option value="make_selected_special"><?= __('Make selected special', 'webafra-fara-search'); ?></option>
                     <option value="make_selected_out_of_special"><?= __('make selected out of special', 'webafra-fara-search'); ?></option>
                     <option value="make_selected_ignore"><?= __('Make selected ignore', 'webafra-fara-search'); ?></option>
                     <option value="make_selected_out_of_ignore"><?= __('make selected out of ignore', 'webafra-fara-search'); ?></option>
                  </select>
                  <input type="submit" name="wf_bulk_action" class="button" value="<?= __('Do action', 'webafra-fara-search'); ?>">

                  <div style="width:100%;">
                     <select name="filter_by" id="filter_by" class="dropdown">
                        <option value=""><?= __('Select', 'webafra-fara-search'); ?>...</option>
                        <option value="is_special" <?= isset($_GET['filter_by']) && $_GET['filter_by'] == 'is_special' ? 'selected="selected"' : ''; ?>><?= __('Is special', 'webafra-fara-search'); ?></option>
                        <option value="is_not_special" <?= isset($_GET['filter_by']) && $_GET['filter_by'] == 'is_not_special' ? 'selected="selected"' : ''; ?>><?= __('Is not special', 'webafra-fara-search'); ?></option>
                        <option value="is_ignored" <?= isset($_GET['filter_by']) && $_GET['filter_by'] == 'is_ignored' ? 'selected="selected"' : ''; ?>><?= __('Is ignored', 'webafra-fara-search'); ?></option>
                        <option value="is_not_ignored" <?= isset($_GET['filter_by']) && $_GET['filter_by'] == 'is_not_ignored' ? 'selected="selected"' : ''; ?>><?= __('Is not ignored', 'webafra-fara-search'); ?></option>
                        <option value="has_result" <?= isset($_GET['filter_by']) && $_GET['filter_by'] == 'has_result' ? 'selected="selected"' : ''; ?>><?= __('Has result', 'webafra-fara-search'); ?></option>
                        <option value="has_no_result" <?= isset($_GET['filter_by']) && $_GET['filter_by'] == 'has_no_result' ? 'selected="selected"' : ''; ?>><?= __('Has no result', 'webafra-fara-search'); ?></option>
                     </select>

                     <select name="filter_by_form" id="filter_by_form" class="dropdown">
                        <option value=""><?= __('Select form', 'webafra-fara-search'); ?>...</option>
                        <?php if (!empty($forms_raw)) : ?>
                           <?php foreach ($forms_raw as $form) : ?>
                              <option value="<?= $form->id; ?>" <?= isset($_GET['filter_by_form']) && $_GET['filter_by_form'] == $form->id ? 'selected="selected"' : ''; ?>><?= $form->title; ?></option>
                           <?php endforeach; ?>
                        <?php endif; ?>
                     </select>

                     <input type="search" name="search" value="<?= isset($_GET['search']) ? $_GET['search'] : ''; ?>" placeholder="<?= __('Search', 'webafra-fara-search'); ?>..." style="width:150px;">

                     <?php
                     $filter_date_template = wfs_PP . '/templates/admin/filter-by-created-at.php';

                     if (file_exists($filter_date_template)) {
                        include $filter_date_template;
                     }
                     ?>

                     <input type="submit" name="filter_action" class="button" value="<?= __('Filter', 'webafra-fara-search'); ?>">
                  </div>

               </div>
               <div class="controls-left">
                  <div><?= $search_keywords->total_item; ?> <?php _e('item', 'webafra-fara-search'); ?></div>
                  <div class="per-pages">
                     <div><?php _e('Show', 'webafra-fara-search'); ?>: </div>
                     <select name="per_pages_top" id="per_pages_top" class="dropdown">
                        <?php foreach ($this->per_pages_items as $per_pages_item) : ?>
                           <option value="<?= $per_pages_item; ?>" <?= isset($args['per_pages']) && $args['per_pages'] == $per_pages_item ? 'selected' : ''; ?>><?= $per_pages_item; ?></option>
                        <?php endforeach; ?>
                     </select>
                     <input type="submit" name="per_pages_top_action" class="button" value="<?= __('Change', 'webafra-fara-search'); ?>">
                  </div>
               </div>
            </div>
            <table class="wfs-table">
               <thead>
                  <tr>
                     <th scope="col">
                        <input type="checkbox" onchange="wac_tables_check_all(this, '<?= !is_null($search_keywords->data) && count($search_keywords->data) ? count($search_keywords->data) : 0; ?>')" value="">
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'text' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=text&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('Word', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'text' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th scope="col">
                        <?php _e('Form id', 'webafra-fara-search'); ?>
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'is_special' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=is_special&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('is Special', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'is_special' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'is_ignored' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=is_ignored&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('is Ignored', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'is_ignored' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'count' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=count&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('Count', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'count' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'has_result' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=has_result&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('Has result', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'has_result' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'created_at' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                        <a href="<?= $this->request_uri; ?>&orderby=created_at&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                           <?php _e('Created at', 'webafra-fara-search'); ?>
                           <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'created_at' ? 'visible' : ''; ?>"></span>
                           <span class="sorting-indicators">
                              <span class="sorting-indicator asc" aria-hidden="true"></span>
                              <span class="sorting-indicator desc" aria-hidden="true"></span>
                           </span>
                        </a>
                     </th>
                     <th><?php _e('Action', 'webafra-fara-search'); ?></th>
                  </tr>
               </thead>
               <tbody>
                  <?php if (!is_null($search_keywords->data) && count($search_keywords->data)) : ?>
                     <?php $bulk_tmp_index = 0; ?>
                     <?php foreach ($search_keywords->data as $search_keyword) : $form_data = WFS_DB_Queries::get_form($search_keyword->form_id);  ?>
                        <tr>
                           <td>
                              <input type="checkbox" name="bulk_items[]" id="bulk_items_checkbox_<?= $bulk_tmp_index; ?>" value="<?= $search_keyword->id; ?>">
                           </td>
                           <td scope="col"><?= $search_keyword->text; ?></td>
                           <td scope="col"><?= $form_data ? $form_data->title : $search_keyword->form_id; ?></td>
                           <td scope="col">
                              <?php if ($search_keyword->is_special) : ?>
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#559a00" stroke-width="4" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                 </svg>
                              <?php else : ?>
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#d0021b" stroke-width="4" stroke-linecap="round" stroke-linejoin="round">
                                    <line x1="18" y1="6" x2="6" y2="18"></line>
                                    <line x1="6" y1="6" x2="18" y2="18"></line>
                                 </svg>
                              <?php endif; ?>
                           </td>
                           <td scope="col">
                              <?php if ($search_keyword->is_ignored) : ?>
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#559a00" stroke-width="4" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                 </svg>
                              <?php else : ?>
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#d0021b" stroke-width="4" stroke-linecap="round" stroke-linejoin="round">
                                    <line x1="18" y1="6" x2="6" y2="18"></line>
                                    <line x1="6" y1="6" x2="18" y2="18"></line>
                                 </svg>
                              <?php endif; ?>
                           </td>
                           <td scope="col">
                              <?= $search_keyword->count ?>
                           </td>
                           <td scope="col">
                              <?php if ($search_keyword->has_result) : ?>
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#559a00" stroke-width="4" stroke-linecap="round" stroke-linejoin="round">
                                    <polyline points="20 6 9 17 4 12"></polyline>
                                 </svg>
                              <?php else : ?>
                                 <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#d0021b" stroke-width="4" stroke-linecap="round" stroke-linejoin="round">
                                    <line x1="18" y1="6" x2="6" y2="18"></line>
                                    <line x1="6" y1="6" x2="18" y2="18"></line>
                                 </svg>
                              <?php endif; ?>
                           </td>
                           <td scope="col">
                              <?php if ($search_keyword->created_at) : ?>
                                 <span class="wfs-date"><?= wac_date($search_keyword->created_at, get_option('wff_settings_date_calendar', 'gregorian_calendar'), 'Y-m-d H:i:s'); ?></span>
                              <?php else : ?>
                                 -
                              <?php endif; ?>
                           </td>
                           <td>
                              <ul class="wfs-action-options icon-action">
                                 <li>
                                    <a title="<?php _e('Edit keyword', 'webafra-fara-search'); ?>" href="javascript:void(0);" onclick="wac_change_css_displaying('#wfs-search-keyword-edit-<?= $search_keyword->id; ?>');">
                                       <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#0080C0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                          <path d="M20 14.66V20a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h5.34"></path>
                                          <polygon points="18 2 22 6 12 16 8 16 8 12 18 2"></polygon>
                                       </svg>
                                    </a>
                                 </li>
                                 <li>
                                    <a title="<?php _e('Delete keyword', 'webafra-fara-search'); ?>" href="javascript:void(0);" onclick="wac_change_css_displaying('#wfs-search-keyword-delete-<?= $search_keyword->id; ?>');">
                                       <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                          <polyline points="3 6 5 6 21 6"></polyline>
                                          <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                          <line x1="10" y1="11" x2="10" y2="17"></line>
                                          <line x1="14" y1="11" x2="14" y2="17"></line>
                                       </svg>
                                    </a>
                                 </li>
                              </ul>
                           </td>
                        </tr>
                        <?php $bulk_tmp_index++; ?>
                     <?php endforeach; ?>
                  <?php else : ?>
                     <tr>
                        <td colspan="10" style="text-align:center;"><?php _e('No item found.', 'webafra-fara-search'); ?></td>
                     </tr>
                  <?php endif; ?>
               </tbody>
            </table>
            <div class="content-controls">
               <div class="controls-right">
                  <?php if (!is_null($search_keywords->total_page) && !empty($search_keywords->total_page) && $search_keywords->total_page > 1) : ?>
                     <?= wac_pagination(intval($search_keywords->total_page)); ?>
                  <?php endif; ?>
               </div>
               <div class="controls-left">
                  <div><?= $search_keywords->total_item; ?> <?php _e('item', 'webafra-fara-search'); ?></div>
                  <div class="per-pages">
                     <div><?php _e('Show', 'webafra-fara-search'); ?>: </div>
                     <select name="per_pages_bottom" id="per_pages_bottom" class="dropdown">
                        <?php foreach ($this->per_pages_items as $per_pages_item) : ?>
                           <option value="<?= $per_pages_item; ?>" <?= isset($args['per_pages']) && $args['per_pages'] == $per_pages_item ? 'selected' : ''; ?>><?= $per_pages_item; ?></option>
                        <?php endforeach; ?>
                     </select>
                     <input type="submit" name="per_pages_bottom_action" class="button" value="<?= __('Change', 'webafra-fara-search'); ?>">
                  </div>
               </div>
            </div>
         </form>
      <?php endif; ?>
      <script>
         wac_register_range_datepicker('<?= get_option('wfs_settings_calendar', 'gregorian'); ?>', '<?= get_locale(); ?>', '#filter_by_date_start', '#filter_by_date_end');
      </script>
   </div>
</div>