<?php
if (!defined('ABSPATH') || !is_admin() || !current_user_can('manage_options')) {
   die;
}
?>
<div class="wfs-main">
   <div class="wfs-heading header">
      <h1><?php _e('Forms', 'webafra-fara-search'); ?></h1>
      <div style="display:flex;gap:1rem;">
         <button type="button" class="wfs-button svg-medium" onclick="wac_change_css_displaying('#wfs_create_new_form_popup');">
            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
               <path d="M3 3h18v18H3zM12 8v8m-4-4h8" />
            </svg>
            <?php _e('Add new form', 'webafra-fara-search'); ?>
         </button>
      </div>
   </div>
   <div class="wfs-content">
      <?php if (!empty($this->error)) : ?>
         <div class="wfs-alert danger"><?= $this->error; ?></div>
      <?php endif; ?>
      <?php if (!is_null($search_forms->data) && count($search_forms->data)) : ?>
         <?php foreach ($search_forms->data as $search_form) : ?>
            <form action="<?= $this->request_uri; ?>" method="POST">
               <div class="wfs-popup-overlay" id="wfs_delete_form_delete_<?= $search_form->id; ?>">
                  <div class="wfs-popup">
                     <input type="hidden" name="wfs_delete_form_delete_id" value="<?= $search_form->id; ?>" />
                     <div class="heading header">
                        <h3><?php _e('Delete form', 'webafra-fara-search'); ?> <span class="heading-badge"><?php _e('Id', 'webafra-fara-search'); ?>: #<?= $search_form->id; ?></span>
                        </h3>
                        <a class="close-btn" onclick="wac_change_css_displaying('#wfs_delete_form_delete_<?= $search_form->id; ?>', 'none');" href="javascript:void(0);">
                           <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="butt" stroke-linejoin="arcs">
                              <line x1="18" y1="6" x2="6" y2="18"></line>
                              <line x1="6" y1="6" x2="18" y2="18"></line>
                           </svg>
                        </a>
                     </div>
                     <div class="wfs-popup-content">
                        <p><?php _e('Delete form permanently.', 'webafra-fara-search'); ?></p>
                     </div>
                     <div class="heading footer">
                        <div></div>
                        <div style="display:flex;flex-direction:row;gap:.5rem;">
                           <button type="submit" name="wfs_delete_form_submit" class="wfs-button svg-medium danger">
                              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#ffffff" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                 <polyline points="3 6 5 6 21 6"></polyline>
                                 <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                 <line x1="10" y1="11" x2="10" y2="17"></line>
                                 <line x1="14" y1="11" x2="14" y2="17"></line>
                              </svg>
                              <?php _e('Delete', 'webafra-fara-search'); ?>
                           </button>
                        </div>
                     </div>
                  </div>
               </div>
            </form>
         <?php endforeach; ?>
      <?php endif; ?>
      <form action="<?= $this->request_uri; ?>" method="POST">
         <div class="wfs-popup-overlay" id="wfs_create_new_form_popup">
            <div class="wfs-popup">
               <div class="heading header">
                  <h3><?php _e('New form', 'webafra-fara-search'); ?></h3>
                  <a class="close-btn" onclick="wac_change_css_displaying('#wfs_create_new_form_popup', 'none');" href="javascript:void(0);">
                     <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="butt" stroke-linejoin="arcs">
                        <line x1="18" y1="6" x2="6" y2="18"></line>
                        <line x1="6" y1="6" x2="18" y2="18"></line>
                     </svg>
                  </a>
               </div>
               <div class="wfs-popup-content">
                  <div class="wfs-rows gap-medium nbb">
                     <div class="wfs-columns w-49">
                        <label class="mb-10" for="form_title"><?php _e('Title', 'webafra-fara-search'); ?></label>
                        <input type="text" class="wfs-input w-100" id="form_title" name="form_title" value="" required />
                     </div>
                     <div class="wfs-columns w-49">
                        <label class="mb-10" for="form_status"><?php _e('Status', 'webafra-fara-search'); ?></label>
                        <select id="form_status" name="form_status" class="wfs-input wfs-select w-100" required>
                           <?php foreach ($this->form_status as $status_key => $status) : ?>
                              <option value="<?= $status_key; ?>"><?= $status; ?></option>
                           <?php endforeach; ?>
                        </select>
                     </div>
                  </div>
               </div>
               <div class="heading footer">
                  <div></div>
                  <div style="display:flex;flex-direction:row;gap:.5rem;">
                     <button type="submit" name="wfs_create_new_form_submit" class="wfs-button svg-medium">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M3 3h18v18H3zM12 8v8m-4-4h8" />
                        </svg>
                        <?php _e('Create', 'webafra-fara-search'); ?>
                     </button>
                  </div>
               </div>
            </div>
         </div>
      </form>
      <form action="" method="POST" class="form-inputs">
         <div class="content-controls">
            <div class="controls-right">
               <select name="bulk_action" id="bulk_action" class="dropdown">
                  <option value="-1" selected="selected"><?= __('Bulk actions', 'webafra-fara-search'); ?></option>
                  <option value="delete_selected"><?= __('Delete selected', 'webafra-fara-search'); ?></option>
               </select>
               <input type="submit" name="wf_bulk_action" class="button" value="<?= __('Do action', 'webafra-fara-search'); ?>">
            </div>
            <div class="controls-left">
               <div><?= $search_forms->total_item; ?> <?php _e('item', 'webafra-fara-search'); ?></div>
               <div class="per-pages">
                  <div><?php _e('Show', 'webafra-fara-search'); ?>: </div>
                  <select name="per_pages_top" id="per_pages_top" class="dropdown">
                     <?php foreach ($this->per_pages_items as $per_pages_item) : ?>
                        <option value="<?= $per_pages_item; ?>" <?= isset($args['per_pages']) && $args['per_pages'] == $per_pages_item ? 'selected' : ''; ?>><?= $per_pages_item; ?></option>
                     <?php endforeach; ?>
                  </select>
                  <input type="submit" name="per_pages_top_action" class="button" value="<?= __('Change', 'webafra-fara-search'); ?>">
               </div>
            </div>
         </div>
         <table class="wfs-table">
            <thead>
               <tr>
                  <th scope="col">
                     <input type="checkbox" onchange="wac_tables_check_all(this, '<?= !is_null($search_forms->data) && count($search_forms->data) ? count($search_forms->data) : 0; ?>')" value="">
                  </th>
                  <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'title' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                     <a href="<?= $this->request_uri; ?>&orderby=title&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                        <?php _e('Title', 'webafra-fara-search'); ?>
                        <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'title' ? 'visible' : ''; ?>"></span>
                        <span class="sorting-indicators">
                           <span class="sorting-indicator asc" aria-hidden="true"></span>
                           <span class="sorting-indicator desc" aria-hidden="true"></span>
                        </span>
                     </a>
                  </th>
                  <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'status' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                     <a href="<?= $this->request_uri; ?>&orderby=status&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                        <?php _e('Status', 'webafra-fara-search'); ?>
                        <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'status' ? 'visible' : ''; ?>"></span>
                        <span class="sorting-indicators">
                           <span class="sorting-indicator asc" aria-hidden="true"></span>
                           <span class="sorting-indicator desc" aria-hidden="true"></span>
                        </span>
                     </a>
                  </th>
                  <th scope="col" class="<?= isset($_GET['orderby']) && $_GET['orderby'] == 'created_at' ? 'sorted ' : ''; ?> <?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'asc' : 'desc'; ?>">
                     <a href="<?= $this->request_uri; ?>&orderby=created_at&order=<?= isset($_GET['order']) && $_GET['order'] == 'ASC' ? 'DESC' : 'ASC'; ?>">
                        <?php _e('Created at', 'webafra-fara-search'); ?>
                        <span class="sorting-indicator <?= isset($_GET['orderby']) && $_GET['orderby'] == 'created_at' ? 'visible' : ''; ?>"></span>
                        <span class="sorting-indicators">
                           <span class="sorting-indicator asc" aria-hidden="true"></span>
                           <span class="sorting-indicator desc" aria-hidden="true"></span>
                        </span>
                     </a>
                  </th>
                  <th scope="col"><?php _e('Shortcode', 'webafra-fara-search'); ?></th>
                  <th><?php _e('Action', 'webafra-fara-search'); ?></th>
               </tr>
            </thead>
            <tbody>
               <?php if (!is_null($search_forms->data) && count($search_forms->data)) : ?>
                  <?php $bulk_tmp_index = 0; ?>
                  <?php foreach ($search_forms->data as $search_form) : ?>
                     <tr>
                        <td>
                           <input type="checkbox" name="bulk_items[]" id="bulk_items_checkbox_<?= $bulk_tmp_index; ?>" value="<?= $search_form->id; ?>">
                        </td>
                        <td scope="col">
                           <?= $search_form->title; ?>
                           <ul class="wfs-action-options wrap">
                              <li><?= __('Id', 'webafra-fara-search'); ?> <span><?= $search_form->id; ?></span></li>
                              <li><a href="admin.php?page=wfs-search-forms&form_id=<?= $search_form->id; ?>&tab=general"><?= __('Edit', 'webafra-fara-search'); ?></a></li>
                              <li><a href="admin.php?page=wfs-search-logs&tab=keywords&filter_by_form=<?= $search_form->id; ?>"><?= __('Search logs', 'webafra-fara-search'); ?></a></li>
                              <li><a href="<?= get_site_url(); ?>?wfs_preview=<?= $search_form->id; ?>"><?= __('Preview', 'webafra-fara-search'); ?></a></li>
                           </ul>
                        </td>
                        <td scope="col">
                           <div class="wfs-status-toggle <?= $search_form->status; ?>"><?= $this->form_status[$search_form->status]; ?></div>
                        </td>
                        <td scope="col"><span class="wfs-date"><?= wac_date($search_form->created_at, get_option('wff_settings_date_calendar', 'gregorian_calendar'), 'Y-m-d H:i:s'); ?></span></td>
                        <td><code>[wfs_render form_id=<?= $search_form->id; ?>]</code></td>
                        <td>
                           <ul class="wfs-action-options icon-action">
                              <li>
                                 <a title="<?php _e('Edit form', 'webafra-fara-search'); ?>" href="admin.php?page=wfs-search-forms&form_id=<?= $search_form->id; ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="#0080C0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                       <path d="M20 14.66V20a2 2 0 0 1-2 2H4a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h5.34"></path>
                                       <polygon points="18 2 22 6 12 16 8 16 8 12 18 2"></polygon>
                                    </svg>
                                 </a>
                              </li>
                              <li>
                                 <a title="<?php _e('Delete form', 'webafra-fara-search'); ?>" href="javascript:void(0);" onclick="wac_change_css_displaying('#wfs_delete_form_delete_<?= $search_form->id; ?>');">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="red" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                       <polyline points="3 6 5 6 21 6"></polyline>
                                       <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                       <line x1="10" y1="11" x2="10" y2="17"></line>
                                       <line x1="14" y1="11" x2="14" y2="17"></line>
                                    </svg>
                                 </a>
                              </li>
                           </ul>
                        </td>
                     </tr>
                     <?php $bulk_tmp_index++; ?>
                  <?php endforeach; ?>
               <?php else : ?>
                  <tr>
                     <td colspan="6" style="text-align:center;"><?php _e('No item found.', 'webafra-fara-search'); ?></td>
                  </tr>
               <?php endif; ?>
            </tbody>
         </table>
         <div class="content-controls">
            <div class="controls-right">
               <?php if (!is_null($search_forms->total_page) && !empty($search_forms->total_page) && $search_forms->total_page > 1) : ?>
                  <?= wac_pagination(intval($search_forms->total_page)); ?>
               <?php endif; ?>
            </div>
            <div class="controls-left">
               <div><?= $search_forms->total_item; ?> <?php _e('item', 'webafra-fara-search'); ?></div>
               <div class="per-pages">
                  <div><?php _e('Show', 'webafra-fara-search'); ?>: </div>
                  <select name="per_pages_bottom" id="per_pages_bottom" class="dropdown">
                     <?php foreach ($this->per_pages_items as $per_pages_item) : ?>
                        <option value="<?= $per_pages_item; ?>" <?= isset($args['per_pages']) && $args['per_pages'] == $per_pages_item ? 'selected' : ''; ?>><?= $per_pages_item; ?></option>
                     <?php endforeach; ?>
                  </select>
                  <input type="submit" name="per_pages_bottom_action" class="button" value="<?= __('Change', 'webafra-fara-search'); ?>">
               </div>
            </div>
         </div>
      </form>
   </div>
</div>