<?php
if (!defined('ABSPATH') || !is_admin() || !current_user_can('manage_options')) {
   die;
}
?>
<div class="wfs-main">
   <form action="<?= $this->request_uri; ?>" method="POST">
      <div class="wfs-popup-overlay" id="wfs_form_preview_popup">
         <div class="wfs-popup wide">
            <div class="heading header">
               <h3><?php _e('Preview', 'webafra-fara-search'); ?></h3>
               <a class="close-btn" onclick="wac_change_css_displaying('#wfs_form_preview_popup', 'none');" href="javascript:void(0);">
                  <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="butt" stroke-linejoin="arcs">
                     <line x1="18" y1="6" x2="6" y2="18"></line>
                     <line x1="6" y1="6" x2="18" y2="18"></line>
                  </svg>
               </a>
            </div>
            <div class="wfs-popup-content np">
               <div class="wfs-iframe-base">
                  <iframe src="<?= get_site_url(); ?>?wfs_preview=<?= $form_id; ?>"></iframe>
               </div>
            </div>
         </div>
      </div>
   </form>
   <form action="<?= $this->request_uri; ?>" method="POST">
      <div class="wfs-heading form sticky-top">
         <ul>
            <li class="<?= $current_tab == 'general' ? 'active' : ''; ?>">
               <a href="admin.php?page=wfs-search-forms&form_id=<?= $form_id; ?>&tab=general"><?php _e('General', 'webafra-fara-search'); ?></a>
            </li>
            <li class="<?= $current_tab == 'style' ? 'active' : ''; ?>">
               <a href="admin.php?page=wfs-search-forms&form_id=<?= $form_id; ?>&tab=style"><?php _e('Style', 'webafra-fara-search'); ?></a>
            </li>
            <li class="<?= $current_tab == 'translate' ? 'active' : ''; ?>">
               <a href="admin.php?page=wfs-search-forms&form_id=<?= $form_id; ?>&tab=translate"><?php _e('Translate', 'webafra-fara-search'); ?></a>
            </li>
         </ul>
         <div style="display:flex;gap:1rem;">
            <button type="button" class="wfs-button orange-light svg-medium" onclick="wac_change_css_displaying('#wfs_form_preview_popup');">
               <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                  <path d="M1 12s4-8 11-8 11 8 11 8-4 8-11 8-11-8-11-8z"></path>
                  <circle cx="12" cy="12" r="3"></circle>
               </svg>
               <?php _e('Preview', 'webafra-fara-search'); ?>
            </button>
            <button type="submit" name="form_edit_submit" class="wfs-button svg-medium">
               <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                  <path d="M19 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h11l5 5v11a2 2 0 0 1-2 2z"></path>
                  <polyline points="17 21 17 13 7 13 7 21"></polyline>
                  <polyline points="7 3 7 8 15 8"></polyline>
               </svg>
               <?php _e('Save', 'webafra-fara-search'); ?>
            </button>
         </div>
      </div>
      <div class="wfs-content">
         <?php if (!empty($this->error)) : ?>
            <?php if (is_array($this->error)) : ?>
               <div class="wfs-alert list danger">
                  <?php foreach ($this->error as $error) : ?>
                     <li><?= $error; ?></li>
                  <?php endforeach; ?>
               </div>
            <?php else : ?>
               <div class="wfs-alert danger"><?= $this->error; ?></div>
            <?php endif; ?>
         <?php endif; ?>
         <?php if (isset($_GET['success']) && $_GET['success'] == '1' && empty($this->error)) : ?>
            <div class="wfs-alert success"><?= __('Settings saved.', 'webafra-fara-search'); ?></div>
         <?php endif; ?>
         <?php if ($current_tab == 'general') : ?>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#settings_general_icon', '#settings_general');">
                  <?= __('General', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="settings_general_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="settings_general">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="form_title"><?php _e('Title', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <input type="text" class="wfs-input" id="form_title" name="form_title" value="<?= $form_data->title; ?>" />
                     </div>
                  </div>
                  <div class="wfs-rows">
                     <div class="wfs-columns w-25">
                        <label for="form_status"><?php _e('Status', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <select id="form_status" name="form_status" class="wfs-input wfs-select">
                           <?php foreach ($this->form_status as $status_key => $status) : ?>
                              <option value="<?= $status_key; ?>" <?= $form_data->status == $status_key ? 'selected' : ''; ?>><?= $status; ?></option>
                           <?php endforeach; ?>
                        </select>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="use_other_search_results_page"><?php _e('Use other search result page', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="checkbox" id="use_other_search_results_page" class="wfs-input ui-toggle" name="use_other_search_results_page" value="1" <?= $form_data->form_options['use_other_search_results_page'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#use_other_search_results_page_controls');" />
                        </div>
                     </div>
                  </div>
                  <div id="use_other_search_results_page_controls" style="display:<?= isset($form_data->form_options['use_other_search_results_page']) && $form_data->form_options['use_other_search_results_page'] == 1 ? 'block' : 'none'; ?>">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="form_submit_redirect_to"><?php _e('Search result page', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('Page slug', 'webafra-fara-search'); ?>)</span></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="text" class="wfs-input ltr" id="form_submit_redirect_to" name="form_submit_redirect_to" value="<?= is_null($form_data->form_options['form_submit_redirect_to']) ? '' : $form_data->form_options['form_submit_redirect_to_slug']; ?>" />
                        </div>
                     </div>

                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="search_query_var"><?php _e('Search query var', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="text" class="wfs-input ltr" id="search_query_var" name="search_query_var" value="<?= $form_data->form_options['search_query_var']; ?>" />
                        </div>
                     </div>

                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="post_type_query_var"><?php _e('Post type query var', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="text" class="wfs-input ltr" id="post_type_query_var" name="post_type_query_var" value="<?= $form_data->form_options['post_type_query_var']; ?>" />
                        </div>
                     </div>

                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="category_query_var"><?php _e('Category query var', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="text" class="wfs-input ltr" id="category_query_var" name="category_query_var" value="<?= $form_data->form_options['category_query_var']; ?>" />
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#settings_layout_icon', '#settings_layout');">
                  <?= __('Layout', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="settings_layout_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="settings_layout">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="layout"><?php _e('Layout', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <select id="layout" name="layout" class="wfs-input wfs-select" onchange="wfs_visibility_layout_controls(this)">
                              <option value="simple" <?= $form_data->form_options['layout'] == 'simple' ? 'selected' : ''; ?>><?= __('Simple', 'webafra-fara-search'); ?></option>
                              <option value="popup" <?= $form_data->form_options['layout'] == 'popup' ? 'selected' : ''; ?>><?= __('Popup', 'webafra-fara-search'); ?></option>
                           </select>
                        </div>
                     </div>
                  </div>
                  <div id="layout_popup_controls" style="display:<?= $form_data->form_options['layout'] == 'popup' ? 'block' : 'none'; ?>;">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="layout_popup_type"><?php _e('Popup type', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <div class="wfs-columns">
                              <select id="layout_popup_type" name="layout_popup_type" class="wfs-input wfs-select">
                                 <option value="normal" <?= $form_data->form_options['layout_popup_type'] == 'normal' ? 'selected' : ''; ?>><?= __('Normal', 'webafra-fara-search'); ?></option>
                                 <option value="floating" <?= $form_data->form_options['layout_popup_type'] == 'floating' ? 'selected' : ''; ?>><?= __('Floating', 'webafra-fara-search'); ?></option>
                              </select>
                           </div>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="layout_popup_action_button"><?php _e('Popup button', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <div class="wfs-columns">
                              <select id="layout_popup_action_button" name="layout_popup_action_button" class="wfs-input wfs-select" onchange="wfs_visibility_layout_popup_button_controls(this)">
                                 <option value="none" <?= $form_data->form_options['layout_popup_action_button'] == 'none' ? 'selected' : ''; ?>><?= __('None', 'webafra-fara-search'); ?></option>
                                 <option value="static" <?= $form_data->form_options['layout_popup_action_button'] == 'static' ? 'selected' : ''; ?>><?= __('Static', 'webafra-fara-search'); ?></option>
                                 <option value="fixed" <?= $form_data->form_options['layout_popup_action_button'] == 'fixed' ? 'selected' : ''; ?>><?= __('Fixed', 'webafra-fara-search'); ?></option>
                              </select>
                           </div>
                        </div>
                     </div>
                     <div id="layout_popup_action_button_controls" style="display:<?= $form_data->form_options['layout_popup_action_button'] != 'none' ? 'block' : 'none'; ?>;">
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns w-25">
                              <label for="layout_popup_action_button_icon">
                                 <?php _e('Popup button icon', 'webafra-fara-search'); ?>
                                 <div style="color:#707070;font-size:12px;"><?php _e('Allowed formats', 'webafra-fara-search'); ?>: svg, png, jpg, webp</div>
                              </label>
                           </div>
                           <div class="wfs-columns w-75">
                              <div class="wfs-columns do-flex">
                                 <?php
                                 $layout_popup_action_button_icon = false;
                                 if (isset($form_data->form_options['layout_popup_action_button_icon']) && is_numeric($form_data->form_options['layout_popup_action_button_icon'])) {
                                    $layout_popup_action_button_icon = wp_get_attachment_image_src($form_data->form_options['layout_popup_action_button_icon'], 'thumbnail');
                                 }
                                 ?>
                                 <div id="layout_popup_action_button_icon_preview" style="width:32px; display: <?= $layout_popup_action_button_icon ? 'block' : 'none' ?>;"><img style="width:100%;height:auto;" src="<?= $layout_popup_action_button_icon ? $layout_popup_action_button_icon[0] : ''; ?>" /></div>
                                 <div style="display:flex;gap:10px;">
                                    <input type="hidden" id="layout_popup_action_button_icon" class="wfs-input" name="layout_popup_action_button_icon" value="<?= $form_data->form_options['layout_popup_action_button_icon']; ?>" style="display:none!important;" />
                                    <input type="button" class="button" id="layout_popup_action_button_icon_clear" onclick="wfs_media_clear('#layout_popup_action_button_icon')" value="<?= __('Remove', 'webafra-fara-search'); ?>" style="display:<?= !empty($form_data->form_options['layout_popup_action_button_icon']) ? 'block' : 'none'; ?>;">
                                    <input type="button" class="button" onclick="wfs_media_upload(this, '#layout_popup_action_button_icon', ['image/svg+xml', 'image/png', 'image/jpeg', 'image/webp'])" value="<?= __('Select', 'webafra-fara-search'); ?>">
                                 </div>
                              </div>
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns w-25">
                              <label for="layout_popup_action_button_text"><?php _e('Popup button text', 'webafra-fara-search'); ?></label>
                           </div>
                           <div class="wfs-columns w-75">
                              <div class="wfs-columns">
                                 <input type="text" class="wfs-input" id="layout_popup_action_button_text" name="layout_popup_action_button_text" value="<?= $form_data->form_options['layout_popup_action_button_text']; ?>" />
                              </div>
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns w-25">
                              <label for="layout_popup_button_tooltip_text"><?php _e('Popup button tooltip text', 'webafra-fara-search'); ?></label>
                           </div>
                           <div class="wfs-columns w-75">
                              <div class="wfs-columns">
                                 <input type="text" class="wfs-input" id="layout_popup_button_tooltip_text" name="layout_popup_button_tooltip_text" value="<?= $form_data->form_options['layout_popup_button_tooltip_text']; ?>" />
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>

                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="layout_popup_action_class"><?php _e('Popup action class', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="text" class="wfs-input ltr" id="layout_popup_action_class" name="layout_popup_action_class" value="<?= $form_data->form_options['layout_popup_action_class']; ?>" />
                        </div>
                        <div class="wfs-alert">
                           <p><?= __('Open or jump to the search form by the name of the desired class, enter your desired class without dot.', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#form_post_types_icon', '#form_post_types');">
                  <?= __('Post type', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="form_post_types_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="form_post_types">
                  <?php
                  $search_result_post_types = [];
                  if (isset($form_data->form_options['search_result_post_types']) && !empty($form_data->form_options['search_result_post_types'])) {
                     $search_result_post_types = explode(',', $form_data->form_options['search_result_post_types']);
                  }
                  ?>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_result_post_types"><?php _e('Post type', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <select id="search_result_post_types" name="search_result_post_types[]" class="wfs-input wfs-select" multiple>
                           <?php foreach (wac_get_post_types() as $post_type_key => $post_type) : ?>
                              <option <?= in_array($post_type_key, $search_result_post_types) ? 'selected' : ''; ?> value="<?= $post_type_key; ?>"><?= $post_type->label; ?></option>
                           <?php endforeach; ?>
                        </select>
                        <p class="note"><?php _e('Note', 'webafra-fara-search'); ?>: <?php _e('Search results will be in these post types.', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="default_post_type"><?php _e('Default post type', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <select id="default_post_type" name="default_post_type" class="wfs-input wfs-select">
                           <?php foreach (wac_get_post_types() as $post_type_key => $post_type) : ?>
                              <option <?= isset($form_data->form_options['default_post_type']) && $form_data->form_options['default_post_type'] == $post_type_key ? 'selected' : ''; ?> value="<?= $post_type_key; ?>"><?= $post_type->label; ?></option>
                           <?php endforeach; ?>
                        </select>
                        <p class="note"><?php _e('Note', 'webafra-fara-search'); ?>: <?php _e('Default post type must be in post types above and will be use for redirect to search results page.', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <?php if (in_array('product', $search_result_post_types)) : ?>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="show_post_type_product_results_price"><?php _e('Show product price in results', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <div class="wfs-columns">
                              <input type="checkbox" id="show_post_type_product_results_price" class="wfs-input ui-toggle" name="show_post_type_product_results_price" value="1" <?= $form_data->form_options['show_post_type_product_results_price'] == 1 ? 'checked' : ''; ?> />
                           </div>
                        </div>
                     </div>
                  <?php endif; ?>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="show_post_type_select"><?php _e('Show dropdown', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="checkbox" id="show_post_type_select" class="wfs-input ui-toggle" name="show_post_type_select" value="1" <?= $form_data->form_options['show_post_type_select'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#show_post_type_select_controls');" />
                        </div>
                     </div>
                  </div>
                  <div id="show_post_type_select_controls" style="display:<?= isset($form_data->form_options['show_post_type_select']) && $form_data->form_options['show_post_type_select'] == 1 ? 'block' : 'none'; ?>">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="post_type_select_location"><?php _e('Location', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <select id="post_type_select_location" name="post_type_select_location" class="wfs-input wfs-select">
                              <option <?= isset($form_data->form_options['post_type_select_location']) && $form_data->form_options['post_type_select_location'] == 'right' ? 'selected' : ''; ?> value="right"><?php _e('Right', 'webafra-fara-search'); ?></option>
                              <option <?= isset($form_data->form_options['post_type_select_location']) && $form_data->form_options['post_type_select_location'] == 'left' ? 'selected' : ''; ?> value="left"><?php _e('Left', 'webafra-fara-search'); ?></option>
                           </select>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="dropdown_source"><?php _e('Dropdown source', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <select id="dropdown_source" name="dropdown_source" class="wfs-input wfs-select">
                              <option <?= isset($form_data->form_options['dropdown_source']) && $form_data->form_options['dropdown_source'] == 'post_type' ? 'selected' : ''; ?> value="post_type"><?php _e('Post type', 'webafra-fara-search'); ?></option>
                              <option <?= isset($form_data->form_options['dropdown_source']) && $form_data->form_options['dropdown_source'] == 'taxonomy' ? 'selected' : ''; ?> value="taxonomy"><?php _e('Taxonomy', 'webafra-fara-search'); ?></option>
                           </select>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="taxonomy_dropdown"><?php _e('Taxonomy', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <select id="taxonomy_dropdown" name="taxonomy_dropdown" class="wfs-input wfs-select" multiple>
                              <?php foreach ($taxonomies as $tax_key => $tax) : ?>
                                 <option <?= isset($form_data->form_options['taxonomy_dropdown']) && $form_data->form_options['taxonomy_dropdown'] == $tax_key ? 'selected' : ''; ?> value="<?= $tax_key; ?>"><?= $tax->label; ?></option>
                              <?php endforeach; ?>
                           </select>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#settings_search_form_icon', '#settings_search_form');">
                  <?= __('Search form', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="settings_search_form_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="settings_search_form">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="input_placeholder"><?php _e('Placeholder', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <input type="text" class="wfs-input" id="input_placeholder" name="input_placeholder" value="<?= $form_data->form_options['input_placeholder']; ?>" />
                     </div>
                  </div>

                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="input_keyup_delay"><?php _e('Keyup delay', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('In Milliseconds', 'webafra-fara-search'); ?>)</span></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <input type="number" min="0" max="900" class="wfs-input" id="input_keyup_delay" name="input_keyup_delay" value="<?= $form_data->form_options['input_keyup_delay']; ?>" />
                     </div>
                  </div>

                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="form_icon"><?php _e('Icon', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('Allowed formats', 'webafra-fara-search'); ?>: svg, png, jpg, webp)</span></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns do-flex">
                           <div id="form_icon_preview" style="width:32px; display: <?= $form_icon !== false ? 'block' : 'none' ?>;"><img style="width:100%;height:auto;" src="<?= $form_icon !== false ? $form_icon[0] : ''; ?>" /></div>
                           <div style="display:flex;gap:10px;">
                              <input type="hidden" id="form_icon" class="wfs-input" name="form_icon" value="<?= $form_data->form_options['form_icon']; ?>" style="display:none!important;" />
                              <input type="button" class="button" id="form_icon_clear" onclick="wfs_media_clear('#form_icon')" value="<?= __('Remove', 'webafra-fara-search'); ?>" style="display:<?= !empty($form_data->form_options['form_icon']) ? 'block' : 'none'; ?>;">
                              <input type="button" class="button" onclick="wfs_media_upload(this, '#form_icon', ['image/svg+xml', 'image/png', 'image/jpeg', 'image/webp'])" value="<?= __('Select', 'webafra-fara-search'); ?>">
                           </div>
                        </div>
                     </div>
                  </div>

                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_autocomplete"><?php _e('Autocomplete', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="checkbox" id="search_autocomplete" class="wfs-input ui-toggle" name="search_autocomplete" value="1" <?= $form_data->form_options['search_autocomplete'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#search_autocomplete_controls');" />
                        </div>
                     </div>
                  </div>
                  <div id="search_autocomplete_controls" style="display:<?= $form_data->form_options['search_autocomplete'] == 1 ? 'block' : 'none'; ?>;">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25 do-flex">
                           <label for="search_autocomplete_by"><?php _e('Autocomplete by', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <select id="search_autocomplete_by" name="search_autocomplete_by" class="wfs-input wfs-select">
                              <option <?= isset($form_data->form_options['search_autocomplete_by']) && $form_data->form_options['search_autocomplete_by'] == 'keywords' ? 'selected' : ''; ?> value="keywords"><?php _e('Keywords', 'webafra-fara-search'); ?></option>
                              <option <?= isset($form_data->form_options['search_autocomplete_by']) && $form_data->form_options['search_autocomplete_by'] == 'posts' ? 'selected' : ''; ?> value="posts"><?php _e('Posts', 'webafra-fara-search'); ?></option>
                           </select>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#settings_search_result_icon', '#settings_search_result');">
                  <?= __('Search result', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="settings_search_result_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="settings_search_result">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_result_limit"><?php _e('Limit', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <input type="number" min="1" max="20" class="wfs-input" id="search_result_limit" name="search_result_limit" value="<?= $form_data->form_options['search_result_limit']; ?>" />
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_result_title_limit"><?php _e('Title character limit', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <input type="number" min="1" max="1000" class="wfs-input" id="search_result_title_limit" name="search_result_title_limit" value="<?= $form_data->form_options['search_result_title_limit']; ?>" />
                     </div>
                  </div>

                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_result_carousel"><?php _e('Slider', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="checkbox" id="search_result_carousel" class="wfs-input ui-toggle" name="search_result_carousel" value="1" <?= $form_data->form_options['search_result_carousel'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#search_result_carousel_controls');" />
                        </div>
                     </div>
                  </div>
                  <div id="search_result_carousel_controls" style="display:<?= $form_data->form_options['search_result_carousel'] == 1 ? 'block' : 'none'; ?>;">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25 do-flex">
                           <label for="search_result_carousel_limit"><?php _e('Slider limit', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('search_result_carousel_limit'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'search_result_carousel_limit'); ?>
                        </div>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_result_icon"><?php _e('Icon', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('Allowed formats', 'webafra-fara-search'); ?>: svg, png, jpg, webp)</span></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns do-flex">
                           <div id="search_result_icon_preview" style="width:32px; display: <?= $search_result_icon !== false ? 'block' : 'none' ?>;"><img style="width:100%;height:auto;" src="<?= $search_result_icon !== false ? $search_result_icon[0] : ''; ?>" /></div>
                           <div style="display:flex;gap:10px;">
                              <input type="hidden" id="search_result_icon" class="wfs-input" name="search_result_icon" value="<?= $form_data->form_options['search_result_icon']; ?>" style="display:none!important;" />
                              <input type="button" class="button" id="search_result_icon_clear" onclick="wfs_media_clear('#search_result_icon')" value="<?= __('Remove', 'webafra-fara-search'); ?>" style="display:<?= !empty($form_data->form_options['search_result_icon']) ? 'block' : 'none'; ?>;">
                              <input type="button" class="button" onclick="wfs_media_upload(this, '#search_result_icon', ['image/svg+xml', 'image/png', 'image/jpeg', 'image/webp'])" value="<?= __('Select', 'webafra-fara-search'); ?>">
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#settings_search_in_categories_icon', '#settings_search_in_categories');">
                  <?= __('Search in post type categories', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="settings_search_in_categories_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="settings_search_in_categories">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_in_post_type_categories"><?php _e('Enable', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="checkbox" id="search_in_post_type_categories" class="wfs-input ui-toggle" name="search_in_post_type_categories" value="1" <?= $form_data->form_options['search_in_post_type_categories'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#search_in_post_type_categories_controls');" />
                        </div>
                     </div>
                  </div>
                  <div id="search_in_post_type_categories_controls" style="display:<?= $form_data->form_options['search_in_post_type_categories'] == 1 ? 'block' : 'none'; ?>;">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="search_in_post_type_categories_title"><?php _e('Title', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="text" class="wfs-input" id="search_in_post_type_categories_title" name="search_in_post_type_categories_title" value="<?= $form_data->form_options['search_in_post_type_categories_title']; ?>" />
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="search_in_post_type_categories_limit"><?php _e('Limit', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="number" min="1" max="20" class="wfs-input" id="search_in_post_type_categories_limit" name="search_in_post_type_categories_limit" value="<?= $form_data->form_options['search_in_post_type_categories_limit']; ?>" />
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="search_in_post_type_categories_hide_empty"><?php _e('Do not search in empty categories', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <div class="wfs-columns">
                              <input type="checkbox" id="search_in_post_type_categories_hide_empty" class="wfs-input ui-toggle" name="search_in_post_type_categories_hide_empty" value="1" <?= $form_data->form_options['search_in_post_type_categories_hide_empty'] == 1 ? 'checked' : ''; ?> />
                           </div>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="search_in_post_type_categories_exclude_tax"><?php _e('Exclude taxonomies', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <select id="search_in_post_type_categories_exclude_tax" name="search_in_post_type_categories_exclude_tax[]" class="wfs-input wfs-select" multiple>
                              <?php foreach ($taxonomies as $tax_key => $tax) : ?>
                                 <option <?= isset($form_data->form_options['search_in_post_type_categories_exclude_tax']) && in_array($tax_key, explode(',', $form_data->form_options['search_in_post_type_categories_exclude_tax']) !== false ? explode(',', $form_data->form_options['search_in_post_type_categories_exclude_tax']) : []) ? 'selected' : ''; ?> value="<?= $tax_key; ?>"><?= $tax->label; ?></option>
                              <?php endforeach; ?>
                           </select>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="search_in_post_type_categories_icon"><?php _e('Icon', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('Allowed formats', 'webafra-fara-search'); ?>: svg, png, jpg, webp)</span></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <div class="wfs-columns do-flex">
                              <div id="search_in_post_type_categories_icon_preview" style="width:32px; display: <?= $search_in_post_type_categories_icon !== false ? 'block' : 'none' ?>;"><img style="width:100%;height:auto;" src="<?= $search_in_post_type_categories_icon !== false ? $search_in_post_type_categories_icon[0] : ''; ?>" /></div>
                              <div style="display:flex;gap:10px;">
                                 <input type="hidden" id="search_in_post_type_categories_icon" class="wfs-input" name="search_in_post_type_categories_icon" value="<?= $form_data->form_options['search_in_post_type_categories_icon']; ?>" style="display:none!important;" />
                                 <input type="button" class="button" id="search_in_post_type_categories_icon_clear" onclick="wfs_media_clear('#search_in_post_type_categories_icon')" value="<?= __('Remove', 'webafra-fara-search'); ?>" style="display:<?= !empty($form_data->form_options['search_in_post_type_categories_icon']) ? 'block' : 'none'; ?>;">
                                 <input type="button" class="button" onclick="wfs_media_upload(this, '#search_in_post_type_categories_icon', ['image/svg+xml', 'image/png', 'image/jpeg', 'image/webp'])" value="<?= __('Select', 'webafra-fara-search'); ?>">
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#settings_related_result_icon', '#settings_related_result');">
                  <?= __('Related result', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="settings_related_result_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="settings_related_result">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_result_limit"><?php _e('Limit', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <input type="number" min="1" max="20" class="wfs-input" id="settings_related_limit" name="settings_related_limit" value="<?= $form_data->form_options['settings_related_limit']; ?>" />
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_result_icon"><?php _e('Icon', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('Allowed formats', 'webafra-fara-search'); ?>: svg, png, jpg, webp)</span></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns do-flex">
                           <div id="settings_related_icon_preview" style="width:32px; display: <?= $settings_related_icon !== false ? 'block' : 'none' ?>;"><img style="width:100%;height:auto;" src="<?= $settings_related_icon !== false ? $settings_related_icon[0] : ''; ?>" /></div>
                           <div style="display:flex;gap:10px;">
                              <input type="hidden" id="settings_related_icon" class="wfs-input" name="settings_related_icon" value="<?= $form_data->form_options['settings_related_icon']; ?>" style="display:none!important;" />
                              <input type="button" class="button" id="settings_related_icon_clear" onclick="wfs_media_clear('#settings_related_icon')" value="<?= __('Remove', 'webafra-fara-search'); ?>" style="display:<?= !empty($form_data->form_options['settings_related_icon']) ? 'block' : 'none'; ?>;">
                              <input type="button" class="button" onclick="wfs_media_upload(this, '#settings_related_icon', ['image/svg+xml', 'image/png', 'image/jpeg', 'image/webp'])" value="<?= __('Select', 'webafra-fara-search'); ?>">
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#settings_search_banner_icon', '#settings_search_banner');">
                  <?= __('Search banner', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="settings_search_banner_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="settings_search_banner">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="search_banner_enable"><?php _e('Enable', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="checkbox" id="search_banner_enable" class="wfs-input ui-toggle" name="search_banner_enable" value="1" <?= $form_data->form_options['search_banner_enable'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#search_banner_controls');" />
                        </div>
                     </div>
                  </div>
                  <div id="search_banner_controls" style="display:<?= $form_data->form_options['search_banner_enable'] == 1 ? 'block' : 'none'; ?>;">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="search_banner_image"><?php _e('Image', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('Allowed formats', 'webafra-fara-search'); ?>: svg, png, jpg, webp)</span></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <div class="wfs-columns do-flex">
                              <div id="search_banner_image_preview" style="width:150px; display: <?= $banner_image !== false ? 'block' : 'none' ?>;"><img style="width:100%;height:auto;" src="<?= $banner_image !== false ? $banner_image[0] : ''; ?>" /></div>
                              <div style="display:flex;gap:10px;">
                                 <input type="hidden" id="search_banner_image" class="wfs-input" name="search_banner_image" value="<?= $form_data->form_options['search_banner_image']; ?>" style="display:none!important;" />
                                 <input type="button" class="button" id="search_banner_image_clear" onclick="wfs_media_clear('#search_banner_image')" value="<?= __('Remove', 'webafra-fara-search'); ?>" style="display:<?= !empty($form_data->form_options['search_banner_image']) ? 'block' : 'none'; ?>;">
                                 <input type="button" class="button" onclick="wfs_media_upload(this, '#search_banner_image')" value="<?= __('Select', 'webafra-fara-search'); ?>">
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="search_banner_image_size"><?php _e('Image size', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <select id="search_banner_image_size" name="search_banner_image_size" class="wfs-input wfs-select">
                              <?php foreach (wfs_thumbnail_sizes() as $thumbnail_key => $thumbnail) : ?>
                                 <option value="<?= $thumbnail_key; ?>" <?= $form_data->form_options['search_banner_image_size'] == $thumbnail_key ? 'selected' : ''; ?>><?= $thumbnail; ?></option>
                              <?php endforeach; ?>
                           </select>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="search_banner_url"><?php _e('Url', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="text" class="wfs-input ltr" id="search_banner_url" name="search_banner_url" value="<?= $form_data->form_options['search_banner_url']; ?>" />
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#settings_user_last_searches_icon', '#settings_user_last_searches');">
                  <?= __('User last searches', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="settings_user_last_searches_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="settings_user_last_searches">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="user_last_searches_enable"><?php _e('Enable', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="checkbox" id="user_last_searches_enable" class="wfs-input ui-toggle" name="user_last_searches_enable" value="1" <?= $form_data->form_options['user_last_searches_enable'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#user_last_searches_controls');" />
                        </div>
                     </div>
                  </div>
                  <div id="user_last_searches_controls" style="display:<?= $form_data->form_options['user_last_searches_enable'] == 1 ? 'block' : 'none'; ?>;">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="user_last_searches_title"><?php _e('Title', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="text" class="wfs-input" id="user_last_searches_title" name="user_last_searches_title" value="<?= $form_data->form_options['user_last_searches_title']; ?>" />
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="user_last_searches_icon"><?php _e('Icon', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('Allowed formats', 'webafra-fara-search'); ?>: svg, png, jpg, webp)</span></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <div class="wfs-columns do-flex">
                              <div id="user_last_searches_icon_preview" style="width:32px; display: <?= $user_last_searches_icon !== false ? 'block' : 'none' ?>;"><img style="width:100%;height:auto;" src="<?= $user_last_searches_icon !== false ? $user_last_searches_icon[0] : ''; ?>" /></div>
                              <div style="display:flex;gap:10px;">
                                 <input type="hidden" id="user_last_searches_icon" class="wfs-input" name="user_last_searches_icon" value="<?= $form_data->form_options['user_last_searches_icon']; ?>" style="display:none!important;" />
                                 <input type="button" class="button" id="user_last_searches_icon_clear" onclick="wfs_media_clear('#user_last_searches_icon')" value="<?= __('Remove', 'webafra-fara-search'); ?>" style="display:<?= !empty($form_data->form_options['user_last_searches_icon']) ? 'block' : 'none'; ?>;">
                                 <input type="button" class="button" onclick="wfs_media_upload(this, '#user_last_searches_icon', ['image/svg+xml', 'image/png', 'image/jpeg', 'image/webp'])" value="<?= __('Select', 'webafra-fara-search'); ?>">
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#settings_papular_searches_icon', '#settings_papular_searches');">
                  <?= __('Hot searches', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="settings_papular_searches_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="settings_papular_searches">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="papular_searches_enable"><?php _e('Enable', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="checkbox" id="papular_searches_enable" class="wfs-input ui-toggle" name="papular_searches_enable" value="1" <?= $form_data->form_options['papular_searches_enable'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#papular_searches_controls');" />
                        </div>
                     </div>
                  </div>
                  <div id="papular_searches_controls" style="display:<?= $form_data->form_options['papular_searches_enable'] == 1 ? 'block' : 'none'; ?>;">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="papular_searches_title"><?php _e('Title', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="text" class="wfs-input" id="papular_searches_title" name="papular_searches_title" value="<?= $form_data->form_options['papular_searches_title']; ?>" />
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="papular_searches_range"><?php _e('Range', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="number" class="wfs-input ltr" id="papular_searches_range_start" value="<?= $form_data->form_options['papular_searches_range_start']; ?>" name="papular_searches_range_start" placeholder="<?= __('Start', 'webafra-fara-search'); ?>" autocomplete="off">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="papular_searches_icon"><?php _e('Icon', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('Allowed formats', 'webafra-fara-search'); ?>: svg, png, jpg, webp)</span></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <div class="wfs-columns do-flex">
                              <div id="papular_searches_icon_preview" style="width:32px; display: <?= $papular_searches_icon !== false ? 'block' : 'none' ?>;"><img style="width:100%;height:auto;" src="<?= $papular_searches_icon !== false ? $papular_searches_icon[0] : ''; ?>" /></div>
                              <div style="display:flex;gap:10px;">
                                 <input type="hidden" id="papular_searches_icon" class="wfs-input" name="papular_searches_icon" value="<?= $form_data->form_options['papular_searches_icon']; ?>" style="display:none!important;" />
                                 <input type="button" class="button" id="papular_searches_icon_clear" onclick="wfs_media_clear('#papular_searches_icon')" value="<?= __('Remove', 'webafra-fara-search'); ?>" style="display:<?= !empty($form_data->form_options['papular_searches_icon']) ? 'block' : 'none'; ?>;">
                                 <input type="button" class="button" onclick="wfs_media_upload(this, '#papular_searches_icon', ['image/svg+xml', 'image/png', 'image/jpeg', 'image/webp'])" value="<?= __('Select', 'webafra-fara-search'); ?>">
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#suggested_categories_box_icon', '#suggested_categories_box');">
                  <?= __('Suggested categories', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="suggested_categories_box_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="suggested_categories_box">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns w-25">
                        <label for="suggested_categories_enable"><?php _e('Enable', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75">
                        <div class="wfs-columns">
                           <input type="checkbox" id="suggested_categories_enable" class="wfs-input ui-toggle" name="suggested_categories_enable" value="1" <?= $form_data->form_options['suggested_categories_enable'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#suggested_categories_controls');" />
                        </div>
                     </div>
                  </div>
                  <div id="suggested_categories_controls" style="display:<?= $form_data->form_options['suggested_categories_enable'] == 1 ? 'block' : 'none'; ?>;">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="suggested_categories_title"><?php _e('Title', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="text" class="wfs-input" id="suggested_categories_title" name="suggested_categories_title" value="<?= $form_data->form_options['suggested_categories_title']; ?>" />
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="suggested_categories_ids"><?php _e('Groups', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <select id="suggested_categories_ids" name="suggested_categories_ids[]" class="wfs-input wfs-select" multiple>
                              <?php foreach ($suggested_categories_ids_to_opt as $cat_key => $cat) : ?>
                                 <option value="<?= $cat_key; ?>" selected="selected"><?= $cat; ?></option>
                              <?php endforeach; ?>
                           </select>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns w-25">
                           <label for="suggested_categories_icon"><?php _e('Icon', 'webafra-fara-search'); ?> <span style="color:#707070;font-size:12px;">(<?php _e('Allowed formats', 'webafra-fara-search'); ?>: svg, png, jpg, webp)</span></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <div class="wfs-columns do-flex">
                              <div id="suggested_categories_icon_preview" style="width:32px; display: <?= $suggested_categories_icon !== false ? 'block' : 'none' ?>;"><img style="width:100%;height:auto;" src="<?= $suggested_categories_icon !== false ? $suggested_categories_icon[0] : ''; ?>" /></div>
                              <div style="display:flex;gap:10px;">
                                 <input type="hidden" id="suggested_categories_icon" class="wfs-input" name="suggested_categories_icon" value="<?= $form_data->form_options['suggested_categories_icon']; ?>" style="display:none!important;" />
                                 <input type="button" class="button" id="suggested_categories_icon_clear" onclick="wfs_media_clear('#suggested_categories_icon')" value="<?= __('Remove', 'webafra-fara-search'); ?>" style="display:<?= !empty($form_data->form_options['suggested_categories_icon']) ? 'block' : 'none'; ?>;">
                                 <input type="button" class="button" onclick="wfs_media_upload(this, '#suggested_categories_icon', ['image/svg+xml', 'image/png', 'image/jpeg', 'image/webp'])" value="<?= __('Select', 'webafra-fara-search'); ?>">
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <script>
                     jQuery(document).ready(function($) {
                        var sci_obj = {
                           width: '100%',
                           dir: wfs_vars.is_rtl ? 'rtl' : 'ltr',
                           dropdownAutoWidth: true,
                           ajax: {
                              url: wfs_vars.ajax_url,
                              dataType: 'json',
                              type: 'POST',
                              data: function(params) {
                                 var query = {
                                    search: params.term,
                                    nonce: wfs_vars.ajax_nonce,
                                    action: 'wfs_getting_terms',
                                    post_types: '<?= $form_data->form_options['search_result_post_types']; ?>'
                                 }
                                 return query;
                              },
                              processResults: function(data) {
                                 return {
                                    results: data.terms
                                 };
                              },
                           },
                           minimumInputLength: 3,
                        };

                        <?php if (get_locale() == 'fa_IR') : ?>
                           sci_obj.language = {
                              searching: function() {
                                 return "<?php _e('Searching', 'webafra-fara-search'); ?>...";
                              },
                              inputTooShort: function(args) {
                                 return "<?php _e('Please enter more characters', 'webafra-fara-search'); ?>";
                              },
                              noResults: function() {
                                 return "<?php _e('No result', 'webafra-fara-search'); ?>";
                              },
                           };

                        <?php endif; ?>

                        $('#suggested_categories_ids').select2(sci_obj);
                     });
                  </script>
               </div>
            </div>
         <?php elseif ($current_tab == 'style') : ?>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_overlay_collapse_icon', '#style_overlay_collapse');">
                  <?= __('Overlay', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="style_overlay_collapse_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="style_overlay_collapse">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_overlay_enable"><?php _e('Enable', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <input type="checkbox" id="style_overlay_enable" class="wfs-input ui-toggle" name="style_overlay_enable" value="1" <?= $form_data->form_options['style_overlay_enable'] == 1 ? 'checked' : ''; ?> onclick="wac_visibility_toggle(this, '#style_overlay_enable_controls');" />
                     </div>
                  </div>
                  <div id="style_overlay_enable_controls" style="display:<?= $form_data->form_options['style_overlay_enable'] == 1 ? 'block' : 'none'; ?>;">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_overlay_color"><?php _e('Color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_overlay_color" type="text" id="style_overlay_color" value="<?= $form_data->form_options['style_overlay_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_overlay_color']; ?>">
                        </div>
                     </div>
                  </div>
               </div>
            </div>

            <?php if (isset($form_data->form_options['layout']) && $form_data->form_options['layout'] == 'popup') : ?>
               <div class="wac-rows-group">
                  <h3 class="h-box close" onclick="wac_group_collapse(this, '#layout_popup_collapse_icon', '#layout_popup_collapse');">
                     <?= __('Layout', 'webafra-fara-search'); ?>
                     <div class="collapse-icon close" id="layout_popup_collapse_icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M6 9l6 6 6-6" />
                        </svg>
                     </div>
                  </h3>
                  <div class="group-content" id="layout_popup_collapse">
                     <?php if ($form_data->form_options['layout_popup_type'] == 'floating') : ?>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25 do-flex">
                              <label for="layout_popup_type_floating_position"><?php _e('Floating position', 'webafra-fara-search'); ?></label>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex">
                              <select id="layout_popup_type_floating_position" name="layout_popup_type_floating_position" class="wfs-input wfs-select">
                                 <option <?= isset($form_data->form_options['layout_popup_type_floating_position']) && $form_data->form_options['layout_popup_type_floating_position'] == 'right_top' ? 'selected' : ''; ?> value="right_top"><?php _e('Right (Top)', 'webafra-fara-search'); ?></option>
                                 <option <?= isset($form_data->form_options['layout_popup_type_floating_position']) && $form_data->form_options['layout_popup_type_floating_position'] == 'right_bottom' ? 'selected' : ''; ?> value="right_bottom"><?php _e('Right (Bottom)', 'webafra-fara-search'); ?></option>
                                 <option <?= isset($form_data->form_options['layout_popup_type_floating_position']) && $form_data->form_options['layout_popup_type_floating_position'] == 'left_top' ? 'selected' : ''; ?> value="left_top"><?php _e('Left (Top)', 'webafra-fara-search'); ?></option>
                                 <option <?= isset($form_data->form_options['layout_popup_type_floating_position']) && $form_data->form_options['layout_popup_type_floating_position'] == 'left_bottom' ? 'selected' : ''; ?> value="left_bottom"><?php _e('Left (Bottom)', 'webafra-fara-search'); ?></option>
                              </select>
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25 do-flex">
                              <label for="layout_popup_type_floating_right_left"><?php _e('Right / Left', 'webafra-fara-search'); ?></label>
                              <?= wac_form_responsive_control('layout_popup_type_floating_right_left'); ?>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex">
                              <?= wac_form_responsive_input_number($form_data, 'layout_popup_type_floating_right_left'); ?>
                              <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25 do-flex">
                              <label for="layout_popup_type_floating_top_bottom"><?php _e('Top / Bottom', 'webafra-fara-search'); ?></label>
                              <?= wac_form_responsive_control('layout_popup_type_floating_top_bottom'); ?>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex">
                              <?= wac_form_responsive_input_number($form_data, 'layout_popup_type_floating_top_bottom'); ?>
                              <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                           </div>
                        </div>
                     <?php endif; ?>
                     <?php if ($form_data->form_options['layout_popup_action_button'] == 'fixed') : ?>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25 do-flex">
                              <label for="layout_popup_action_button_position"><?php _e('Fixed button position', 'webafra-fara-search'); ?></label>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex">
                              <select id="layout_popup_action_button_position" name="layout_popup_action_button_position" class="wfs-input wfs-select">
                                 <option <?= isset($form_data->form_options['layout_popup_action_button_position']) && $form_data->form_options['layout_popup_action_button_position'] == 'right_top' ? 'selected' : ''; ?> value="right_top"><?php _e('Right (Top)', 'webafra-fara-search'); ?></option>
                                 <option <?= isset($form_data->form_options['layout_popup_action_button_position']) && $form_data->form_options['layout_popup_action_button_position'] == 'right_bottom' ? 'selected' : ''; ?> value="right_bottom"><?php _e('Right (Bottom)', 'webafra-fara-search'); ?></option>
                                 <option <?= isset($form_data->form_options['layout_popup_action_button_position']) && $form_data->form_options['layout_popup_action_button_position'] == 'left_top' ? 'selected' : ''; ?> value="left_top"><?php _e('Left (Top)', 'webafra-fara-search'); ?></option>
                                 <option <?= isset($form_data->form_options['layout_popup_action_button_position']) && $form_data->form_options['layout_popup_action_button_position'] == 'left_bottom' ? 'selected' : ''; ?> value="left_bottom"><?php _e('Left (Bottom)', 'webafra-fara-search'); ?></option>
                              </select>
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25 do-flex">
                              <label for="layout_popup_action_button_right_left"><?php _e('Right / Left', 'webafra-fara-search'); ?></label>
                              <?= wac_form_responsive_control('layout_popup_action_button_right_left'); ?>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex">
                              <?= wac_form_responsive_input_number($form_data, 'layout_popup_action_button_right_left'); ?>
                              <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25 do-flex">
                              <label for="layout_popup_action_button_top_bottom"><?php _e('Top / Bottom', 'webafra-fara-search'); ?></label>
                              <?= wac_form_responsive_control('layout_popup_action_button_top_bottom'); ?>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex">
                              <?= wac_form_responsive_input_number($form_data, 'layout_popup_action_button_top_bottom'); ?>
                              <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                           </div>
                        </div>
                     <?php endif; ?>
                     <?php if ($form_data->form_options['layout_popup_action_button'] != 'none') : ?>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25 do-flex">
                              <label for="layout_popup_action_button_text_font_size"><?php _e('Button Text Font size', 'webafra-fara-search'); ?></label>
                              <?= wac_form_responsive_control('layout_popup_action_button_text_font_size'); ?>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex">
                              <?= wac_form_responsive_input_number($form_data, 'layout_popup_action_button_text_font_size'); ?>
                              <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25">
                              <label for="layout_popup_action_button_background_color"><?php _e('Button background color', 'webafra-fara-search'); ?></label>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                              <input name="layout_popup_action_button_background_color" type="text" id="layout_popup_action_button_background_color" value="<?= $form_data->form_options['layout_popup_action_button_background_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['layout_popup_action_button_background_color']; ?>">
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25">
                              <label for="layout_popup_action_button_text_color"><?php _e('Button text color', 'webafra-fara-search'); ?></label>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                              <input name="layout_popup_action_button_text_color" type="text" id="layout_popup_action_button_text_color" value="<?= $form_data->form_options['layout_popup_action_button_text_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['layout_popup_action_button_text_color']; ?>">
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25 do-flex">
                              <label for="layout_popup_action_button_border_radius"><?php _e('Button Border radius', 'webafra-fara-search'); ?></label>
                              <?= wac_form_responsive_control('layout_popup_action_button_border_radius'); ?>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex">
                              <?= wac_form_responsive_input_number($form_data, 'layout_popup_action_button_border_radius'); ?>
                              <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                           </div>
                        </div>
                        <div class="wfs-rows nbb">
                           <div class="wfs-columns label-bold w-25 do-flex">
                              <label for="layout_popup_action_button_padding"><?php _e('Button Padding', 'webafra-fara-search'); ?></label>
                              <?= wac_form_responsive_control('layout_popup_action_button_padding'); ?>
                           </div>
                           <div class="wfs-columns w-75 desc-right-flex">
                              <?= wac_form_responsive_input_number($form_data, 'layout_popup_action_button_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                              <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                           </div>
                        </div>
                     <?php endif; ?>
                  </div>
               </div>
            <?php endif; ?>

            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_search_form_icon', '#style_search_form');">
                  <?= __('Search form', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="style_search_form_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="style_search_form">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_form_icon_color"><?php _e('Icon color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_form_icon_color" type="text" id="style_form_icon_color" value="<?= $form_data->form_options['style_form_icon_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_form_icon_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_form_icon_size"><?php _e('Icon size', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_form_icon_size'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_form_icon_size'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_form_icon_position"><?php _e('Icon position', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <select id="style_form_icon_position" name="style_form_icon_position" class="wfs-input wfs-select">
                           <option <?= isset($form_data->form_options['style_form_icon_position']) && $form_data->form_options['style_form_icon_position'] == 'row' ? 'selected' : ''; ?> value="row"><?php _e('Right', 'webafra-fara-search'); ?></option>
                           <option <?= isset($form_data->form_options['style_form_icon_position']) && $form_data->form_options['style_form_icon_position'] == 'row-reverse' ? 'selected' : ''; ?> value="row-reverse"><?php _e('Left', 'webafra-fara-search'); ?></option>
                        </select>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_form_icon_padding"><?php _e('Icon padding', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_form_icon_padding'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_form_icon_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_form_text_color"><?php _e('Text color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_form_text_color" type="text" id="style_form_text_color" value="<?= $form_data->form_options['style_form_text_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_form_text_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_form_font_size"><?php _e('Font size', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_form_font_size'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_form_font_size'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_form_background_color"><?php _e('Background color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_form_background_color" type="text" id="style_form_background_color" value="<?= $form_data->form_options['style_form_background_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_form_background_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_form_border_color"><?php _e('Border color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_form_border_color" type="text" id="style_form_border_color" value="<?= $form_data->form_options['style_form_border_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_form_border_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_form_border_width"><?php _e('Border width', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_form_border_width'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_form_border_width', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_form_border_radius"><?php _e('Border radius', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_form_border_radius'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_form_border_radius', ['top_left' => __('Top left', 'webafra-fara-search'), 'top_right' => __('Top right', 'webafra-fara-search'), 'bottom_right' => __('Bottom right', 'webafra-fara-search'), 'bottom_left' => __('Bottom left', 'webafra-fara-search')]); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_form_padding"><?php _e('Padding', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_form_padding'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_form_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
               </div>
            </div>

            <?php if (isset($form_data->form_options['show_post_type_select']) && $form_data->form_options['show_post_type_select'] == 1) : ?>
               <div class="wac-rows-group">
                  <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_search_form_post_type_select_icon', '#style_search_form_post_type_select');">
                     <?= __('Post type select', 'webafra-fara-search'); ?> / <?= __('Category select', 'webafra-fara-search'); ?>
                     <div class="collapse-icon close" id="style_search_form_post_type_select_icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M6 9l6 6 6-6" />
                        </svg>
                     </div>
                  </h3>
                  <div class="group-content" id="style_search_form_post_type_select">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_search_form_post_type_select_text_color"><?php _e('Text color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_search_form_post_type_select_text_color" type="text" id="style_search_form_post_type_select_text_color" value="<?= $form_data->form_options['style_search_form_post_type_select_text_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_search_form_post_type_select_text_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_search_form_post_type_select_font_size"><?php _e('Font size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_search_form_post_type_select_font_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_search_form_post_type_select_font_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_search_form_post_type_select_background_color"><?php _e('Background color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_search_form_post_type_select_background_color" type="text" id="style_search_form_post_type_select_background_color" value="<?= $form_data->form_options['style_search_form_post_type_select_background_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_search_form_post_type_select_background_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_search_form_post_type_select_border_color"><?php _e('Border color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_search_form_post_type_select_border_color" type="text" id="style_search_form_post_type_select_border_color" value="<?= $form_data->form_options['style_search_form_post_type_select_border_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_search_form_post_type_select_border_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_search_form_post_type_select_border_width"><?php _e('Border width', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_search_form_post_type_select_border_width'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_search_form_post_type_select_border_width', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_search_form_post_type_select_border_radius"><?php _e('Border radius', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_search_form_post_type_select_border_radius'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_search_form_post_type_select_border_radius', ['top_left' => __('Top left', 'webafra-fara-search'), 'top_right' => __('Top right', 'webafra-fara-search'), 'bottom_right' => __('Bottom right', 'webafra-fara-search'), 'bottom_left' => __('Bottom left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_search_form_post_type_select_padding"><?php _e('Padding', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_search_form_post_type_select_padding'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_search_form_post_type_select_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_search_form_post_type_select_margin"><?php _e('Margin', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_search_form_post_type_select_margin'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_search_form_post_type_select_margin', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_search_form_post_type_select_hide_on_tablet"><?php _e('Hide on tablet', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="checkbox" id="style_search_form_post_type_select_hide_on_tablet" class="wfs-input ui-toggle" name="style_search_form_post_type_select_hide_on_tablet" value="1" <?= $form_data->form_options['style_search_form_post_type_select_hide_on_tablet'] == 'none' ? 'checked' : ''; ?> />
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_search_form_post_type_select_hide_on_mobile"><?php _e('Hide on mobile', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75">
                           <input type="checkbox" id="style_search_form_post_type_select_hide_on_mobile" class="wfs-input ui-toggle" name="style_search_form_post_type_select_hide_on_mobile" value="1" <?= $form_data->form_options['style_search_form_post_type_select_hide_on_mobile'] == 'none' ? 'checked' : ''; ?> />
                        </div>
                     </div>
                  </div>
               </div>
            <?php endif; ?>

            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_search_box_icon', '#style_search_box');">
                  <?= __('Result box', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="style_search_box_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="style_search_box">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_result_box_max_height"><?php _e('Max height', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_result_box_max_height'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_result_box_max_height'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_result_box_background_color"><?php _e('Background color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_result_box_background_color" type="text" id="style_result_box_background_color" value="<?= $form_data->form_options['style_result_box_background_color']; ?>" data-alpha-enabled="true" <?= $form_data->form_options['style_result_box_background_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_result_box_border_color"><?php _e('Border color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_result_box_border_color" type="text" id="style_result_box_border_color" value="<?= $form_data->form_options['style_result_box_border_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_result_box_border_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_result_box_border_width"><?php _e('Border width', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_result_box_border_width'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_result_box_border_width', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_result_box_border_radius"><?php _e('Border radius', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_result_box_border_radius'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_result_box_border_radius', ['top_left' => __('Top left', 'webafra-fara-search'), 'top_right' => __('Top right', 'webafra-fara-search'), 'bottom_right' => __('Bottom right', 'webafra-fara-search'), 'bottom_left' => __('Bottom left', 'webafra-fara-search')]); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_result_box_e_padding_top"><?php _e('Padding top', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_result_box_e_padding_top'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_result_box_e_padding_top'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_result_box_margin"><?php _e('Margin', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_result_box_margin'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_result_box_margin', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_search_result_icon', '#style_search_result');">
                  <?= __('Search result', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="style_search_result_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="style_search_result">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_search_result_item_icon_color"><?php _e('Item icon color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_search_result_item_icon_color" type="text" id="style_search_result_item_icon_color" value="<?= $form_data->form_options['style_search_result_item_icon_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_search_result_item_icon_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_search_result_item_icon_size"><?php _e('Item icon size', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_search_result_item_icon_size'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_search_result_item_icon_size'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_search_result_item_link_color"><?php _e('Item link color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_search_result_item_link_color" type="text" id="style_search_result_item_link_color" value="<?= $form_data->form_options['style_search_result_item_link_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_search_result_item_link_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_search_result_item_link_hover_color"><?php _e('Item link color', 'webafra-fara-search'); ?> (<?php _e('Hover', 'webafra-fara-search'); ?>)</label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_search_result_item_link_hover_color" type="text" id="style_search_result_item_link_hover_color" value="<?= $form_data->form_options['style_search_result_item_link_hover_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_search_result_item_link_hover_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_search_result_item_link_font_size"><?php _e('Item link font size', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_search_result_item_link_font_size'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_search_result_item_link_font_size'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <?php if ($form_data->form_options['show_post_type_product_results_price']) : ?>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="post_type_product_results_price_color"><?php _e('Product price color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="post_type_product_results_price_color" type="text" id="post_type_product_results_price_color" value="<?= $form_data->form_options['post_type_product_results_price_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['post_type_product_results_price_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="post_type_product_results_price_font_size"><?php _e('Product price font size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('post_type_product_results_price_font_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'post_type_product_results_price_font_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                  <?php endif; ?>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_search_result_item_spacing"><?php _e('Item spacing', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_search_result_item_spacing'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_search_result_item_spacing'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_result_box_padding"><?php _e('Padding', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_result_box_padding'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_result_box_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
               </div>
            </div>
            <div class="wac-rows-group">
               <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_related_result_icon', '#style_related_result');">
                  <?= __('Related result', 'webafra-fara-search'); ?>
                  <div class="collapse-icon close" id="style_related_result_icon">
                     <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M6 9l6 6 6-6" />
                     </svg>
                  </div>
               </h3>
               <div class="group-content" id="style_related_result">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_related_result_icon_color"><?php _e('Icon color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_related_result_icon_color" type="text" id="style_related_result_icon_color" value="<?= $form_data->form_options['style_related_result_icon_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_related_result_icon_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_related_result_icon_size"><?php _e('Icon size', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_related_result_icon_size'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_related_result_icon_size'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_related_result_link_color"><?php _e('Link color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_related_result_link_color" type="text" id="style_related_result_link_color" value="<?= $form_data->form_options['style_related_result_link_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_related_result_link_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_related_result_link_hover_color"><?php _e('Link color', 'webafra-fara-search'); ?> (<?php _e('Hover', 'webafra-fara-search'); ?>)</label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_related_result_link_hover_color" type="text" id="style_related_result_link_hover_color" value="<?= $form_data->form_options['style_related_result_link_hover_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_related_result_link_hover_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_related_result_link_font_size"><?php _e('Link font size', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_related_result_link_font_size'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_related_result_link_font_size'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_related_result_item_spacing"><?php _e('Item spacing', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_related_result_item_spacing'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_related_result_item_spacing'); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25">
                        <label for="style_related_result_border_color"><?php _e('Border color', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                        <input name="style_related_result_border_color" type="text" id="style_related_result_border_color" value="<?= $form_data->form_options['style_related_result_border_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_related_result_border_color']; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-25 do-flex">
                        <label for="style_related_result_border_width"><?php _e('Border width', 'webafra-fara-search'); ?></label>
                        <?= wac_form_responsive_control('style_related_result_border_width'); ?>
                     </div>
                     <div class="wfs-columns w-75 desc-right-flex">
                        <?= wac_form_responsive_input_number($form_data, 'style_related_result_border_width', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                        <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                     </div>
                  </div>
               </div>
            </div>

            <?php if ($form_data->form_options['search_result_carousel']) : ?>
               <div class="wac-rows-group">
                  <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_sr_cis_icon', '#style_sr_cis');">
                     <?= __('Slider', 'webafra-fara-search'); ?>: <?= __('Search result items', 'webafra-fara-search'); ?>
                     <div class="collapse-icon close" id="style_sr_cis_icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M6 9l6 6 6-6" />
                        </svg>
                     </div>
                  </h3>
                  <div class="group-content" id="style_sr_cis">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_sr_ci_background"><?php _e('Background color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_sr_ci_background" type="text" id="style_sr_ci_background" value="<?= $form_data->form_options['style_sr_ci_background']; ?>" data-alpha-enabled="true" <?= $form_data->form_options['style_sr_ci_background']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_sr_ci_border_color"><?php _e('Border color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_sr_ci_border_color" type="text" id="style_sr_ci_border_color" value="<?= $form_data->form_options['style_sr_ci_border_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_sr_ci_border_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_sr_ci_border_width"><?php _e('Border width', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_sr_ci_border_width'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_sr_ci_border_width', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_sr_ci_border_radius"><?php _e('Border radius', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_sr_ci_border_radius'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_sr_ci_border_radius'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_sr_ci_thumbnail_height"><?php _e('Thumbnail height', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_sr_ci_thumbnail_height'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_sr_ci_thumbnail_height'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_sr_ci_padding"><?php _e('Padding', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_sr_ci_padding'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_sr_ci_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                  </div>
               </div>
            <?php endif; ?>

            <?php if ($form_data->form_options['search_banner_enable'] == 1) : ?>
               <div class="wac-rows-group">
                  <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_banner_icon', '#style_banner');">
                     <?= __('Banner', 'webafra-fara-search'); ?>
                     <div class="collapse-icon close" id="style_banner_icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M6 9l6 6 6-6" />
                        </svg>
                     </div>
                  </h3>
                  <div class="group-content" id="style_banner">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_banner_border_radius"><?php _e('Border radius', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_banner_border_radius'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_banner_border_radius'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_banner_padding"><?php _e('Padding', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_banner_padding'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_banner_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_banner_alignment"><?php _e('Alignment', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <select id="style_banner_alignment" name="style_banner_alignment" class="wfs-input wfs-select">
                              <option <?= isset($form_data->form_options['style_banner_alignment']) && $form_data->form_options['style_banner_alignment'] == 'right' ? 'selected' : ''; ?> value="right"><?php _e('Right', 'webafra-fara-search'); ?></option>
                              <option <?= isset($form_data->form_options['style_banner_alignment']) && $form_data->form_options['style_banner_alignment'] == 'center' ? 'selected' : ''; ?> value="center"><?php _e('Center', 'webafra-fara-search'); ?></option>
                              <option <?= isset($form_data->form_options['style_banner_alignment']) && $form_data->form_options['style_banner_alignment'] == 'left' ? 'selected' : ''; ?> value="left"><?php _e('Left', 'webafra-fara-search'); ?></option>
                           </select>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_banner_width"><?php _e('Width', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_banner_width'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_banner_width'); ?>
                           <p class="wfs-field-description"><?php _e('In %', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_banner_height"><?php _e('Height', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_banner_height'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_banner_height'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                  </div>
               </div>
            <?php endif; ?>

            <?php if ($form_data->form_options['user_last_searches_enable'] == 1) : ?>
               <div class="wac-rows-group">
                  <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_user_last_searches_icon', '#style_user_last_searches');">
                     <?= __('User last searches', 'webafra-fara-search'); ?>
                     <div class="collapse-icon close" id="style_user_last_searches_icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M6 9l6 6 6-6" />
                        </svg>
                     </div>
                  </h3>
                  <div class="group-content" id="style_user_last_searches">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_user_last_searches_icon_color"><?php _e('Icon color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_user_last_searches_icon_color" type="text" id="style_user_last_searches_icon_color" value="<?= $form_data->form_options['style_user_last_searches_icon_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_user_last_searches_icon_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_user_last_searches_icon_size"><?php _e('Icon size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_user_last_searches_icon_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_user_last_searches_icon_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_user_last_searches_heading_color"><?php _e('Heading color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_user_last_searches_heading_color" type="text" id="style_user_last_searches_heading_color" value="<?= $form_data->form_options['style_user_last_searches_heading_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_user_last_searches_heading_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_user_last_searches_heading_font_size"><?php _e('Heading font size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_user_last_searches_heading_font_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_user_last_searches_heading_font_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_user_last_searches_heading_margin_bottom"><?php _e('Heading margin bottom', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_user_last_searches_heading_margin_bottom'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_user_last_searches_heading_margin_bottom'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_user_last_searches_item_link_color"><?php _e('Item link color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_user_last_searches_item_link_color" type="text" id="style_user_last_searches_item_link_color" value="<?= $form_data->form_options['style_user_last_searches_item_link_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_user_last_searches_item_link_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_user_last_searches_item_link_hover_color"><?php _e('Item link color', 'webafra-fara-search'); ?> (<?php _e('Hover', 'webafra-fara-search'); ?>)</label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_user_last_searches_item_link_hover_color" type="text" id="style_user_last_searches_item_link_hover_color" value="<?= $form_data->form_options['style_user_last_searches_item_link_hover_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_user_last_searches_item_link_hover_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_user_last_searches_item_link_arrow_color"><?php _e('Item arrow color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_user_last_searches_item_link_arrow_color" type="text" id="style_user_last_searches_item_link_arrow_color" value="<?= $form_data->form_options['style_user_last_searches_item_link_arrow_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_user_last_searches_item_link_arrow_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_user_last_searches_item_link_arrow_hover_color"><?php _e('Item arrow color', 'webafra-fara-search'); ?> (<?php _e('Hover', 'webafra-fara-search'); ?>)</label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_user_last_searches_item_link_arrow_hover_color" type="text" id="style_user_last_searches_item_link_arrow_hover_color" value="<?= $form_data->form_options['style_user_last_searches_item_link_arrow_hover_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_user_last_searches_item_link_arrow_hover_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_user_last_searches_item_link_font_size"><?php _e('Item link font size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_user_last_searches_item_link_font_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_user_last_searches_item_link_font_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_user_last_searches_item_border_radius"><?php _e('Item border radius', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_user_last_searches_item_border_radius'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_user_last_searches_item_border_radius'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_user_last_searches_padding"><?php _e('Padding', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_user_last_searches_padding'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_user_last_searches_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                  </div>
               </div>
            <?php endif; ?>

            <?php if ($form_data->form_options['papular_searches_enable'] == 1) : ?>
               <div class="wac-rows-group">
                  <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_papular_searches_icon', '#style_papular_searches');">
                     <?= __('Hot searches', 'webafra-fara-search'); ?>
                     <div class="collapse-icon close" id="style_papular_searches_icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M6 9l6 6 6-6" />
                        </svg>
                     </div>
                  </h3>
                  <div class="group-content" id="style_papular_searches">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_papular_searches_icon_color"><?php _e('Icon color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_papular_searches_icon_color" type="text" id="style_papular_searches_icon_color" value="<?= $form_data->form_options['style_papular_searches_icon_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_papular_searches_icon_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_papular_searches_icon_size"><?php _e('Icon size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_papular_searches_icon_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_papular_searches_icon_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_papular_searches_heading_color"><?php _e('Heading color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_papular_searches_heading_color" type="text" id="style_papular_searches_heading_color" value="<?= $form_data->form_options['style_papular_searches_heading_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_papular_searches_heading_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_papular_searches_heading_font_size"><?php _e('Heading font size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_papular_searches_heading_font_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_papular_searches_heading_font_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_papular_searches_heading_margin_bottom"><?php _e('Heading margin bottom', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_papular_searches_heading_margin_bottom'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_papular_searches_heading_margin_bottom'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_papular_searches_item_link_color"><?php _e('Item link color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_papular_searches_item_link_color" type="text" id="style_papular_searches_item_link_color" value="<?= $form_data->form_options['style_papular_searches_item_link_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_papular_searches_item_link_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_papular_searches_item_link_hover_color"><?php _e('Item link color', 'webafra-fara-search'); ?> (<?php _e('Hover', 'webafra-fara-search'); ?>)</label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_papular_searches_item_link_hover_color" type="text" id="style_papular_searches_item_link_hover_color" value="<?= $form_data->form_options['style_papular_searches_item_link_hover_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_papular_searches_item_link_hover_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_papular_searches_item_link_arrow_color"><?php _e('Item arrow color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_papular_searches_item_link_arrow_color" type="text" id="style_papular_searches_item_link_arrow_color" value="<?= $form_data->form_options['style_papular_searches_item_link_arrow_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_papular_searches_item_link_arrow_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_papular_searches_item_link_arrow_hover_color"><?php _e('Item arrow color', 'webafra-fara-search'); ?> (<?php _e('Hover', 'webafra-fara-search'); ?>)</label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_papular_searches_item_link_arrow_hover_color" type="text" id="style_papular_searches_item_link_arrow_hover_color" value="<?= $form_data->form_options['style_papular_searches_item_link_arrow_hover_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_papular_searches_item_link_arrow_hover_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_papular_searches_item_link_font_size"><?php _e('Item link font size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_papular_searches_item_link_font_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_papular_searches_item_link_font_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_papular_searches_item_border_radius"><?php _e('Item border radius', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_papular_searches_item_border_radius'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_papular_searches_item_border_radius'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_papular_searches_padding"><?php _e('Padding', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_papular_searches_padding'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_papular_searches_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                  </div>
               </div>
            <?php endif; ?>

            <?php if ($form_data->form_options['suggested_categories_enable'] == 1) : ?>
               <div class="wac-rows-group">
                  <h3 class="h-box close" onclick="wac_group_collapse(this, '#style_suggested_categories_icon', '#style_suggested_categories');">
                     <?= __('Suggested categories', 'webafra-fara-search'); ?>
                     <div class="collapse-icon close" id="style_suggested_categories_icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                           <path d="M6 9l6 6 6-6" />
                        </svg>
                     </div>
                  </h3>
                  <div class="group-content" id="style_suggested_categories">
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_suggested_categories_icon_color"><?php _e('Icon color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_suggested_categories_icon_color" type="text" id="style_suggested_categories_icon_color" value="<?= $form_data->form_options['style_suggested_categories_icon_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_suggested_categories_icon_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_suggested_categories_icon_size"><?php _e('Icon size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_suggested_categories_icon_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_suggested_categories_icon_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_suggested_categories_heading_color"><?php _e('Heading color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_suggested_categories_heading_color" type="text" id="style_suggested_categories_heading_color" value="<?= $form_data->form_options['style_suggested_categories_heading_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_suggested_categories_heading_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_suggested_categories_heading_font_size"><?php _e('Heading font size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_suggested_categories_heading_font_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_suggested_categories_heading_font_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_suggested_categories_heading_margin_bottom"><?php _e('Heading margin bottom', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_suggested_categories_heading_margin_bottom'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_suggested_categories_heading_margin_bottom'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_suggested_categories_item_link_color"><?php _e('Item link color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_suggested_categories_item_link_color" type="text" id="style_suggested_categories_item_link_color" value="<?= $form_data->form_options['style_suggested_categories_item_link_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_suggested_categories_item_link_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_suggested_categories_item_link_hover_color"><?php _e('Item link color', 'webafra-fara-search'); ?> (<?php _e('Hover', 'webafra-fara-search'); ?>)</label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_suggested_categories_item_link_hover_color" type="text" id="style_suggested_categories_item_link_hover_color" value="<?= $form_data->form_options['style_suggested_categories_item_link_hover_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_suggested_categories_item_link_hover_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_suggested_categories_item_link_arrow_color"><?php _e('Item arrow color', 'webafra-fara-search'); ?></label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_suggested_categories_item_link_arrow_color" type="text" id="style_suggested_categories_item_link_arrow_color" value="<?= $form_data->form_options['style_suggested_categories_item_link_arrow_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_suggested_categories_item_link_arrow_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25">
                           <label for="style_suggested_categories_item_link_arrow_hover_color"><?php _e('Item arrow color', 'webafra-fara-search'); ?> (<?php _e('Hover', 'webafra-fara-search'); ?>)</label>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex color-picker-base">
                           <input name="style_suggested_categories_item_link_arrow_hover_color" type="text" id="style_suggested_categories_item_link_arrow_hover_color" value="<?= $form_data->form_options['style_suggested_categories_item_link_arrow_hover_color']; ?>" data-alpha-enabled="true" data-default-color="<?= $form_data->form_options['style_suggested_categories_item_link_arrow_hover_color']; ?>">
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_suggested_categories_item_link_font_size"><?php _e('Item link font size', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_suggested_categories_item_link_font_size'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_suggested_categories_item_link_font_size'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_suggested_categories_item_border_radius"><?php _e('Item border radius', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_suggested_categories_item_border_radius'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_suggested_categories_item_border_radius'); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                     <div class="wfs-rows nbb">
                        <div class="wfs-columns label-bold w-25 do-flex">
                           <label for="style_suggested_categories_padding"><?php _e('Padding', 'webafra-fara-search'); ?></label>
                           <?= wac_form_responsive_control('style_suggested_categories_padding'); ?>
                        </div>
                        <div class="wfs-columns w-75 desc-right-flex">
                           <?= wac_form_responsive_input_number($form_data, 'style_suggested_categories_padding', ['top' => __('Top', 'webafra-fara-search'), 'right' => __('Right', 'webafra-fara-search'), 'bottom' => __('Bottom', 'webafra-fara-search'), 'left' => __('Left', 'webafra-fara-search')]); ?>
                           <p class="wfs-field-description"><?php _e('In Px', 'webafra-fara-search'); ?></p>
                        </div>
                     </div>
                  </div>
               </div>
            <?php endif; ?>
         <?php elseif ($current_tab == 'translate') : ?>
            <div>
               <?php wp_dropdown_languages([
                  'name'                  => 'translate_change_lang_slug',
                  'selected'              => $dropdown_language_selected,
                  'explicit_option_en_us' => true
               ]); ?>
               <input type="submit" name="translate_change_lang_btn" class="button" value="<?= __('Change', 'webafra-fara-search'); ?>">
            </div>
            <div style="display:flex;flex-wrap:wrap;justify-content:space-between;">
               <div style="width:49%;">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-100 mb-05">
                        <label for="input_placeholder"><?= __('Search...', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-100">
                        <input name="input_placeholder" type="text" class="wfs-input w-100" id="input_placeholder" value="<?= isset($form_translates_values['input_placeholder']) ? $form_translates_values['input_placeholder'] : ''; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-100 mb-05">
                        <label for="user_last_searches_title"><?= __('Your last searches', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-100">
                        <input name="user_last_searches_title" type="text" class="wfs-input w-100" id="user_last_searches_title" value="<?= isset($form_translates_values['user_last_searches_title']) ? $form_translates_values['user_last_searches_title'] : ''; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-100 mb-05">
                        <label for="papular_searches_title"><?= __('Hot searches', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-100">
                        <input name="papular_searches_title" type="text" class="wfs-input w-100" id="papular_searches_title" value="<?= isset($form_translates_values['papular_searches_title']) ? $form_translates_values['papular_searches_title'] : ''; ?>">
                     </div>
                  </div>
               </div>
               <div style="width:49%;">
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-100 mb-05">
                        <label for="suggested_categories_title"><?= __('Suggested categories', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-100">
                        <input name="suggested_categories_title" type="text" class="wfs-input w-100" id="suggested_categories_title" value="<?= isset($form_translates_values['suggested_categories_title']) ? $form_translates_values['suggested_categories_title'] : ''; ?>">
                     </div>
                  </div>
                  <div class="wfs-rows nbb">
                     <div class="wfs-columns label-bold w-100 mb-05">
                        <label for="papular_searches_title"><?= __('No result!', 'webafra-fara-search'); ?></label>
                     </div>
                     <div class="wfs-columns w-100">
                        <input name="no_result" type="text" class="wfs-input w-100" id="no_result" value="<?= isset($form_translates_values['no_result']) ? $form_translates_values['no_result'] : ''; ?>">
                     </div>
                  </div>
               </div>
            </div>
         <?php endif; ?>
      </div>
   </form>
</div>