<?php
if (!defined('ABSPATH') || !is_admin() || !current_user_can('manage_options')) {
   die;
}

$filter_date_start   = '';
$filter_date_end     = '';

if (isset($_GET['filter_by_created_at']) && !empty($_GET['filter_by_created_at'])) {
   if (get_option('wfs_settings_calendar', 'gregorian') == 'shamsi_calendar') {
      $filter_date_arr = explode(',', $_GET['filter_by_created_at']);

      if (!empty($filter_date_arr[0])) {
         $start_date = explode('-', $filter_date_arr[0]);
         $filter_date_start = gregorian_to_jalali($start_date[0], $start_date[1], $start_date[2], '-');
      }

      if (!empty($filter_date_arr[1])) {
         $end_date = explode('-', $filter_date_arr[1]);
         $filter_date_end = gregorian_to_jalali($end_date[0], $end_date[1], $end_date[2], '-');
      }
   } elseif (get_option('wfs_settings_calendar', 'gregorian') == 'hijri_calendar') {
      if (class_exists('uCal2')) {
         $hijri = new uCal2();
         $hijri->setLang('ar');

         $filter_date_arr = explode(',', $_GET['filter_by_created_at']);
         if (!empty($filter_date_arr[0])) {
            $start_date = explode('-', $filter_date_arr[0]);
            $filter_date_start = $hijri->g2u($start_date[2], $start_date[1], $start_date[0]);
            $filter_date_start = sprintf('%d-%d-%d', $filter_date_start['year'], $filter_date_start['month'], $filter_date_start['day']);
         }

         if (!empty($filter_date_arr[1])) {
            $end_date = explode('-', $filter_date_arr[1]);
            $filter_date_end = $hijri->g2u($end_date[2], $end_date[1], $end_date[0]);
            $filter_date_end = sprintf('%d-%d-%d', $filter_date_end['year'], $filter_date_end['month'], $filter_date_end['day']);
         }
      }
   } else {
      $filter_date_arr = explode(',', $_GET['filter_by_created_at']);
      if (!empty($filter_date_arr[0])) {
         $filter_date_start = $filter_date_arr[0];
      }

      if (!empty($filter_date_arr[1])) {
         $filter_date_end = $filter_date_arr[1];
      }
   }
}
?>
<input <?= get_option('wfs_settings_calendar', 'gregorian') == 'shamsi_calendar' ? 'data-jdp' : ''; ?> type="text" id="filter_by_date_start" value="<?= $filter_date_start; ?>" name="filter_by_date_start" placeholder="<?= __('Filter by date', 'webafra-fara-search'); ?> (<?= __('Start', 'webafra-fara-search'); ?>)" autocomplete="off">

<input <?= get_option('wfs_settings_calendar', 'gregorian') == 'shamsi_calendar' ? 'data-jdp' : ''; ?> type="text" id="filter_by_date_end" value="<?= $filter_date_end; ?>" name="filter_by_date_end" placeholder="<?= __('Filter by date', 'webafra-fara-search'); ?> (<?= __('End', 'webafra-fara-search'); ?>)" autocomplete="off">