<?php
if (!defined('ABSPATH') || !is_admin() || !current_user_can('manage_options')) {
	die;
}
?>
<div class="dashboard-widget">
	<div class="wfs-rows nbb">
		<div class="wfs-columns w-49">
			<table class="wfs-table border-e1e1e1">
				<thead>
					<tr>
						<th scope="col" style="text-align:center;"><?php _e('Text', 'webafra-fara-search'); ?></th>
						<th scope="col" style="text-align:center;"><?php _e('Count', 'webafra-fara-search'); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php if (!is_null($search_keywords->data) && count($search_keywords->data)) : ?>
						<?php foreach ($search_keywords->data as $keyword) : ?>
							<tr>
								<td scope="col" style="text-align:center;"><?= $keyword->text; ?></td>
								<td scope="col" style="text-align:center;"><?= $keyword->count; ?></td>
							</tr>
						<?php endforeach; ?>
					<?php else : ?>
						<tr>
							<td colspan="3" style="text-align:center;"><?php _e('No item found.', 'webafra-fara-search'); ?></td>
						</tr>
					<?php endif; ?>
				</tbody>
			</table>
			<a href="<?= get_admin_url(); ?>admin.php?page=wfs-search-logs" class="wfs-more-link">
				<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
					<path d="M3 3v18h18" />
					<path d="M18.7 14.3L15 10.5l-2.7 2.7L7 8" />
				</svg>
				<?php _e('More', 'webafra-fara-search'); ?>...
			</a>
		</div>
		<div class="wfs-columns w-49">
			<div class="wfs-keywords-chart">
				<canvas id="wfs-keywords-chart-box"></canvas>
				<script src="<?= wfs_PF; ?>assets/js/chart.js"></script>
				<script type="text/javascript">
					new Chart(document.getElementById('wfs-keywords-chart-box'), {
						type: 'pie',
						data: {
							labels: <?= wp_json_encode(array_map(fn ($record) => $record->text, $search_keywords->data)); ?>,
							datasets: [{
								label: '<?= __('Count', 'webafra-fara-search'); ?>',
								data: <?= wp_json_encode(array_map(fn ($record) => $record->count, $search_keywords->data)); ?>,
								hoverOffset: 4,
							}]
						},
						options: {
							responsive: true,
							plugins: {
								legend: {
									position: 'top',
									labels: {
										font: {
											size: 12,
											family: "'iranyekan-regular', Arial, sans-serif",
										}
									}
								},
							}
						},
					});
				</script>
			</div>
		</div>
	</div>
</div>