<?php
if (!defined('ABSPATH')) {
	die;
}

if (!class_exists('wfs_Widget_Get_Form')) {
	class wfs_Widget_Get_Form extends WP_Widget
	{
		function __construct()
		{
			parent::__construct('wfs_get_form', __('Ajax search form', 'webafra-fara-search'), ['description' => __('Display ajax search form', 'webafra-fara-search')]);
		}

		public function widget($args, $instance)
		{
			if (empty($instance['form_id'])) {
				return;
			}

			echo do_shortcode("[wfs_render form_id={$instance['form_id']}]");
		}

		public function form($instance)
		{
			$form_id = !empty($instance['form_id']) ? $instance['form_id'] : '';

			global $wpdb;

			$forms_raw = WFS_DB_Queries::get_forms_raw(); ?>
			<p>
				<label for="<?= $this->get_field_id('form_id'); ?>"><?= __('Form', 'webafra-fara-search'); ?>:</label>
				<select class="widefat" id="<?= $this->get_field_id('form_id'); ?>" name="<?= $this->get_field_name('form_id'); ?>">
					<?php if (!empty($forms_raw)) : ?>
						<?php foreach ($forms_raw as $form) : ?>
							<option value="<?= $form->id; ?>" <?= $form_id == $form->id ? ' selected' : ''; ?>><?= $form->title; ?></option>
						<?php endforeach; ?>
					<?php endif; ?>
				</select>
			</p>
<?php }

		public function update($new_instance, $old_instance)
		{
			$instance = [];

			$instance['form_id'] = !empty($new_instance['form_id']) ? strip_tags($new_instance['form_id']) : $old_instance['form_id'];

			return $instance;
		}
	}

	add_action('widgets_init', function () {
		register_widget('wfs_Widget_Get_Form');
	});
}
