<?php
if (!defined('ABSPATH')) {
   die;
}

if (!class_exists('wfs_Render')) {
   class wfs_Render
   {
      public static $ins = null;

      public static function ins()
      {
         if (is_null(self::$ins)) {
            self::$ins = new self();
         }

         return self::$ins;
      }

      public function __construct()
      {
         add_action('wp', [$this, 'preview'], 10, 0);

         add_shortcode('wfs_render', [$this, 'shortcode']);

         add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);

         add_filter('pre_get_posts', [$this, 'before_redirect_to_search_results_page']);

         add_action('wp', [$this, 'after_redirect_to_search_results_page'], 11, 0);
      }

      public function enqueue_scripts($hook)
      {
         $version = time();

         wp_enqueue_script('jquery');
         wp_enqueue_style('wfs-owl-carousel2-min', wfs_PF . 'assets/owl.carousel2/owl.carousel.min.css', [], $version);
         wp_enqueue_style('wfs-owl-carousel2-default', wfs_PF . 'assets/owl.carousel2/owl.theme.default.min.css', [], $version);
         wp_enqueue_script('wfs-owl-carousel2-min', wfs_PF . 'assets/owl.carousel2/owl.carousel.min.js', ['jquery'], $version, false);

         wp_enqueue_style('webafra-fara-search', wfs_PF . 'assets/css/theme.css', [], $version);
         wp_enqueue_script('webafra-fara-search', wfs_PF . 'assets/js/theme.js', ['jquery'], $version, false);

         $is_wfs_search = false;
         $wfs_keyword   = '';

         if (isset($_GET['form_id']) && is_numeric($_GET['form_id'])) {
            $get_form = WFS_DB_Queries::get_form((int) $_GET['form_id']);

            if (!is_null($get_form)) {
               if (is_null($get_form->form_options['form_submit_redirect_to'])) {
                  if (is_search()) {
                     $is_wfs_search = true;
                  }
               } else {
                  if (is_page((int) $get_form->form_options['form_submit_redirect_to'])) {
                     $is_wfs_search = true;
                  }
               }

               if (!empty($get_form->form_options['search_query_var'])) {
                  $search_query_var = $get_form->form_options['search_query_var'];

                  if (isset($_GET[$search_query_var]) && !empty($_GET[$search_query_var])) {
                     $wfs_keyword = $_GET[$search_query_var];
                  }
               }
            }
         }

         wp_localize_script('webafra-fara-search', 'wfs_ajax_var', [
            'front_url'       => get_site_url(),
            'url'             => admin_url('admin-ajax.php'),
            'nonce'           => wp_create_nonce('wfs-ajax-nonce'),
            'is_rtl'          => (int) is_rtl(),
            'search_query'    => [
               'is_search' => $is_wfs_search,
               'keyword'   => $wfs_keyword,
            ]
         ]);
      }

      public function before_redirect_to_search_results_page($query)
      {
         if (is_admin()) {
            return $query;
         }

         if (!$query->is_search) {
            return $query;
         }

         if (!isset($_GET['form_id'])) {
            return $query;
         }

         if (!is_numeric($_GET['form_id'])) {
            return $query;
         }

         $get_form = WFS_DB_Queries::get_form((int) $_GET['form_id']);

         if (!$get_form) {
            return $query;
         }

         $category_query_var = isset($get_form->form_options['category_query_var']) && !empty($get_form->form_options['category_query_var']) ? $get_form->form_options['category_query_var'] : 'category_id';

         if (isset($_GET[$category_query_var]) && is_numeric($_GET[$category_query_var])) {
            $query->set('tax_query', [
               [
                  'taxonomy' => $get_form->form_options['taxonomy_dropdown'],
                  'field' => 'term_id',
                  'terms' => $_GET[$category_query_var],
               ]
            ]);
         }

         return $query;
      }

      public function after_redirect_to_search_results_page()
      {
         if (is_admin()) {
            return;
         }

         if (!isset($_GET['form_id'])) {
            return;
         }

         if (!is_numeric($_GET['form_id'])) {
            return;
         }

         $get_form = WFS_DB_Queries::get_form((int) $_GET['form_id']);

         if (is_null($get_form)) {
            return;
         }

         if (is_null($get_form->form_options['form_submit_redirect_to'])) {
            if (!is_search()) {
               return;
            }
         } else {
            if (!is_page((int) $get_form->form_options['form_submit_redirect_to'])) {
               return;
            }
         }

         $search_query_var = $get_form->form_options['search_query_var'];

         if (!isset($_GET[$search_query_var])) {
            return;
         }

         if (empty($_GET[$search_query_var])) {
            return;
         }

         $keyword = esc_attr($_GET[$search_query_var]);
         $keyword = trim($keyword);

         $has_result = 0;

         if (isset($_GET['has_result']) && is_numeric($_GET['has_result'])) {
            $has_result = $_GET['has_result'];
         }

         if (isset($_GET['tracking_code']) && !empty($_GET['tracking_code'])) {
            global $wpdb;

            $check_tracking_code = $wpdb->get_var(
               $wpdb->prepare(
                  "SELECT COUNT(*) FROM `{$wpdb->prefix}wfs_search_logs` WHERE `tracking_code` = %s AND `user_id` = %d AND DATE(created_at) >= %s",
                  (string) $_GET['tracking_code'],
                  get_current_user_id(),
                  current_time('Y-m-d')
               )
            );

            if (!$check_tracking_code) {
               $keyword_id = WFS_DB_Queries::insert_search_keyword($keyword, $get_form->id, $has_result);
               WFS_DB_Queries::insert_search_keyword_daily($get_form->id, $keyword_id);
               WFS_DB_Queries::insert_search_log($keyword, $get_form->id, $has_result);
            }
         }

         // Add keyword into user search history.
         if (get_current_user_id()) {
            global $wpdb;

            $check_keyword = $wpdb->get_row(
               $wpdb->prepare(
                  "SELECT * FROM `{$wpdb->prefix}wfs_search_user_logs` WHERE `text` = %s AND `user_id` = %d",
                  (string) $keyword,
                  get_current_user_id()
               )
            );

            if (!$check_keyword) {
               $wpdb->insert("{$wpdb->prefix}wfs_search_user_logs", [
                  'text'            => (string) $keyword,
                  'count'           => 1,
                  'user_id'         => get_current_user_id(),
                  'created_at'      => current_time('mysql'),
                  'created_at_gmt'  => current_time('mysql', 1),
                  'updated_at'      => current_time('mysql'),
                  'updated_at_gmt'  => current_time('mysql', 1)
               ]);
            } else {
               $wpdb->update("{$wpdb->prefix}wfs_search_user_logs", [
                  'count'           => $check_keyword->count + 1,
                  'updated_at'      => current_time('mysql'),
                  'updated_at_gmt'  => current_time('mysql', 1),
               ], [
                  'id'              => $check_keyword->id
               ]);
            }
         }
      }

      public function shortcode($atts)
      {
         if (!isset($atts['form_id']) || empty($atts['form_id'])) {
            return;
         }

         $atts = shortcode_atts([
            'form_id' => $atts['form_id']
         ], $atts, 'wfs_render');

         $form_data = WFS_DB_Queries::get_form((int) $atts['form_id']);

         if ($form_data === false) {
            return;
         }

         if ($form_data->status == 'disable' && !current_user_can('manage_options')) {
            return;
         }

         if ($form_data->status == 'private' && !current_user_can('manage_options')) {
            return;
         }

         ob_start();

         $tmp_id = $form_data->id . rand(1000, 4000);

         $style_options_tmp = [];

         foreach (WFS_DB_Queries::get_form_options_styles_seeding() as $opt_k => $opt) {
            $style_options_tmp[$opt_k] = isset($form_data->form_options[$opt_k]) ? $form_data->form_options[$opt_k] : $style_options_tmp[$opt_k] = $opt;
         }

         extract($style_options_tmp);

         include wfs_PP . '/templates/render.php';

         return ob_get_clean();
      }

      public function preview()
      {
         if (isset($_GET['wfs_preview']) && is_numeric($_GET['wfs_preview']) && current_user_can('manage_options')) {
            $form_data = WFS_DB_Queries::get_form((int) $_GET['wfs_preview']);

            if ($form_data === false) {
               wp_redirect(get_site_url());
               exit;
            }

            $locate  = get_locale();
            $rtl     = is_rtl() ? 'rtl' : 'ltr';

            echo '<html dir="' . $rtl . '" lang="' . $locate . '">';
            echo '<head>';
            echo '<title>' . __('Ajax search', 'webafra-fara-search') . ' - ' . __('Preview', 'webafra-fara-search') . '</title>';
            echo '<meta charset="' . get_bloginfo('charset') . '" />';
            echo '<meta name="viewport" content="width=device-width, initial-scale=1" />';
            wp_head();
            echo '</head>';
            echo '<body>';
            echo '<div class="wfs-container">';
            echo do_shortcode("[wfs_render form_id={$form_data->id}]");
            echo '</div>';
            wp_footer();
            echo '</body>';
            echo '</html>';

            exit;
         }
      }
   }
   wfs_Render::ins();
}
