<?php
if (!defined('ABSPATH')) {
   die;
}

function wfs_convert_arabic_string_to_persian($string)
{
   $characters = [
      'ك' => 'ک',
      'دِ' => 'د',
      'بِ' => 'ب',
      'زِ' => 'ز',
      'ذِ' => 'ذ',
      'شِ' => 'ش',
      'سِ' => 'س',
      'ى' => 'ی',
      'ي' => 'ی',
      'ة' => 'ه',
      '١' => '۱',
      '٢' => '۲',
      '٣' => '۳',
      '٤' => '۴',
      '٥' => '۵',
      '٦' => '۶',
      '٧' => '۷',
      '٨' => '۸',
      '٩' => '۹',
      '٠' => '۰',
   ];
   
   return str_replace(array_keys($characters), array_values($characters), $string);
}

if (!function_exists('wfs_thumbnail_sizes')) {
   function wfs_thumbnail_sizes()
   {
      $thumbnail_sizes = [];

      if (function_exists('get_intermediate_image_sizes')) {
         foreach (get_intermediate_image_sizes() as $thumbnail) {
            $thumbnail_sizes[$thumbnail] = $thumbnail;
         }
      }

      $thumbnail_sizes['full'] = 'full';

      return $thumbnail_sizes;
   }
}

if (!function_exists('wfs_user_display_name')) {
   function wfs_user_display_name(int $user_id)
   {
      $get_user = get_user_by('ID', $user_id);

      if ($get_user) {
         if (!empty($get_user->display_name)) {
            return (string) $get_user->display_name;
         }
         return (string) $get_user->user_login;
      }

      return (string) $user_id;
   }
}

if (!function_exists('wfs_get_thumbnail_src')) {
   function wfs_get_thumbnail_src(int $thumbnail_id, string $size = 'thumbnail', int $is_post = 0)
   {
      $thumbnail_src = '';

      if (function_exists('wc_placeholder_img_src')) {
         $thumbnail_src = wc_placeholder_img_src();
      }

      if ($is_post) {
         $thumbnail_id = get_post_thumbnail_id($thumbnail_id);
      }

      $thumbnail_image = wp_get_attachment_image_src($thumbnail_id, $size);

      if ($thumbnail_image) {
         $thumbnail_src = (string) $thumbnail_image[0];
      }

      return $thumbnail_src;
   }
}

if (!function_exists('wfs_get_form_translate')) {
   function wfs_get_form_translate(array $form_options, string $translate_name)
   {
      $translates_default = [
         'input_placeholder'           => __('Search...', 'webafra-fara-search'),
         'user_last_searches_title'    => __('Your last searches', 'webafra-fara-search'),
         'papular_searches_title'      => __('Hot searches', 'webafra-fara-search'),
         'suggested_categories_title'  => __('Suggested categories', 'webafra-fara-search'),
         'no_result'                   => __('No result!', 'webafra-fara-search'),
      ];

      $lang = (string) get_locale();

      if (get_current_user_id()) {
         $lang = (string) get_user_locale(get_current_user_id());
      }

      $form_translates_lang = 'translate_' . $lang;

      $form_translates_values = [];
      if (isset($form_options[$form_translates_lang]) && !empty($form_options[$form_translates_lang])) {
         $form_translates_values = (array) $form_options[$form_translates_lang];
      }

      if (!empty($form_translates_values)) {
         if (isset($form_translates_values[$translate_name]) && !empty($form_translates_values[$translate_name])) {
            return (string) $form_translates_values[$translate_name];
         }
      }

      return (string) $translates_default[$translate_name];
   }
}
