<?php

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) {
   die;
}

class wfs_Elementor_Widget extends Widget_Base
{
   public function get_name()
   {
      return 'wfs-elementor-widget-getform';
   }

   public function get_title()
   {
      return esc_html__('Ajax search form', 'webafra-fara-search');
   }

   public function get_icon()
   {
      return 'eicon-site-search';
   }

   public function get_script_depends()
   {
      return [];
   }

   public function get_style_depends()
   {
      return [];
   }

   public function get_categories()
   {
      return ['webafra-widgets'];
   }

   protected function register_controls()
   {
      $this->start_controls_section('select_form', [
         'label'  => esc_html__('Select form', 'webafra-fara-search'),
         'tab'    => Controls_Manager::TAB_CONTENT,
      ]);

      $raw_forms = WFS_DB_Queries::get_forms_raw();
      $forms_refactor = [];

      foreach ($raw_forms as $raw_form) {
         $forms_refactor[$raw_form->id] = $raw_form->title;
      }

      $this->add_control('form_id', [
         'label'        => esc_html__('Form', 'webafra-fara-search'),
         'type'         => \Elementor\Controls_Manager::SELECT,
         'label_block'  => true,
         'multiple'     => false,
         'options'      => $forms_refactor,
         'default'      => [],
      ]);

      $this->end_controls_section();
   }

   protected function render()
   {
      $settings = $this->get_settings_for_display();

      if (!$settings['form_id']) {
         return;
      }

      echo do_shortcode("[wfs_render form_id={$settings['form_id']}]");
   }
}
