<?php
if (!defined('ABSPATH')) {
   die;
}

if (!class_exists('wfs_Elementor_Init')) {
   class wfs_Elementor_Init
   {
      public static $ins = null;

      public static function ins()
      {
         if (is_null(self::$ins)) {
            self::$ins = new self();
         }

         return self::$ins;
      }

      public function __construct()
      {
         $this->register_widgets();
      }

      private function register_widgets()
      {
         if (!class_exists('Webafra_Theme')) {
            add_action('elementor/elements/categories_registered', function ($elements_manager) {
               $elements_manager->add_category('webafra-widgets', [
                  'title' => esc_html__('Webafra: Widgets', 'webafra-fara-search'),
                  'icon' => ''
               ]);
            });
         }

         add_action('elementor/widgets/register', function ($widgets_manager) {
            include_once wfs_PP . '/includes/elementor-widget.php';
            $widgets_manager->register(new \wfs_Elementor_Widget());
         });
      }
   }
   wfs_Elementor_Init::ins();
}
