<?php
if (!defined('ABSPATH')) {
   die;
}

if (!class_exists('WFS_DB_Queries')) {
   class WFS_DB_Queries
   {
      public static $ins = null;

      public static function ins()
      {
         if (is_null(self::$ins)) {
            self::$ins = new self();
         }

         return self::$ins;
      }

      public static function insert_search_log(string $keyword, int $form_id, int $has_result = 0)
      {
         global $wpdb;

         $tracking_code = self::generate_tracking_code();

         $wpdb->insert("{$wpdb->prefix}wfs_search_logs", [
            'text'            => $keyword,
            'form_id'         => $form_id,
            'user_id'         => get_current_user_id(),
            'tracking_code'   => $tracking_code,
            'has_result'      => $has_result,
            'created_at'      => current_time('mysql'),
            'created_at_gmt'  => current_time('mysql', 1)
         ]);

         return $tracking_code;
      }

      public static function delete_search_log(int $id)
      {
         global $wpdb;

         $delete = $wpdb->delete("{$wpdb->prefix}wfs_search_logs", [
            'id' => intval($id)
         ]);

         return $delete;
      }

      public static function delete_search_logs(string $ids)
      {
         global $wpdb;

         $search_logs = $wpdb->query("DELETE FROM {$wpdb->prefix}wfs_search_logs WHERE `id` IN($ids)");

         return (int) $search_logs;
      }

      public static function insert_search_keyword(string $keyword, int $form_id, int $has_result = 0)
      {
         global $wpdb;

         $keyword_data = $wpdb->get_row(
            $wpdb->prepare(
               "SELECT * FROM `{$wpdb->prefix}wfs_search_keywords` WHERE `text` = %s AND `form_id` = %d",
               $keyword,
               $form_id
            )
         );

         if (!$keyword_data) {
            $wpdb->insert("{$wpdb->prefix}wfs_search_keywords", [
               'text'            => $keyword,
               'has_result'      => $has_result,
               'form_id'         => $form_id,
               'created_at'      => current_time('mysql'),
               'created_at_gmt'  => current_time('mysql', 1),
               'updated_at'      => current_time('mysql'),
               'updated_at_gmt'  => current_time('mysql', 1),
            ]);

            return (int) $wpdb->insert_id;
         }

         $wpdb->update("{$wpdb->prefix}wfs_search_keywords", [
            'count'           => $keyword_data->count + 1,
            'has_result'      => $has_result,
            'updated_at'      => current_time('mysql'),
            'updated_at_gmt'  => current_time('mysql', 1),
         ], [
            'id'              => (int) $keyword_data->id
         ]);

         return (int) $keyword_data->id;
      }

      public static function insert_search_keyword_daily(int $form_id, int $keyword_id)
      {
         global $wpdb;

         $keyword_data = $wpdb->get_row(
            $wpdb->prepare(
               "SELECT * FROM `{$wpdb->prefix}wfs_search_keywords` WHERE `id` = %d AND `form_id` = %d",
               $keyword_id,
               $form_id
            )
         );

         if (!$keyword_data) {
            return false;
         }

         $today = current_time('Y-m-d');

         $keyword_daily_data = $wpdb->get_row(
            $wpdb->prepare(
               "SELECT * FROM `{$wpdb->prefix}wfs_search_keywords_daily` WHERE `text` = %s AND `date` = %s AND `form_id` = %d",
               $keyword_data->text,
               $today,
               $form_id
            )
         );

         if (!$keyword_daily_data) {
            $wpdb->insert("{$wpdb->prefix}wfs_search_keywords_daily", [
               'text'         => $keyword_data->text,
               'date'         => $today,
               'form_id'      => $form_id,
               'has_result'   => $keyword_data->has_result,
               'is_ignored'   => $keyword_data->is_ignored,
            ]);

            return (int) $wpdb->insert_id;
         }

         $wpdb->update("{$wpdb->prefix}wfs_search_keywords_daily", [
            'count'        => $keyword_daily_data->count + 1,
            'has_result'   => $keyword_data->has_result,
            'is_ignored'   => $keyword_data->is_ignored,
         ], ['id' => (int) $keyword_daily_data->id]);

         return (int) $keyword_daily_data->id;
      }

      public static function add_search_keyword(array $args)
      {
         global $wpdb;

         $edit_keyword = $wpdb->insert("{$wpdb->prefix}wfs_search_keywords", [
            'text'            => sanitize_text_field($args['text']),
            'form_id'         => sanitize_text_field($args['form_id']),
            'is_special'      => $args['is_special'],
            'is_ignored'      => $args['is_ignored'],
            'created_at'      => current_time('mysql'),
            'created_at_gmt'  => current_time('mysql', 1),
            'updated_at'      => current_time('mysql'),
            'updated_at_gmt'  => current_time('mysql', 1),
         ]);

         return (int) $edit_keyword;
      }

      public static function edit_search_keyword(int $id, array $args)
      {
         global $wpdb;

         if (!$get_keyword = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}wfs_search_keywords WHERE id = %d", $id))) {
            return false;
         }

         $edit_keyword = $wpdb->update("{$wpdb->prefix}wfs_search_keywords", [
            'text'            => sanitize_text_field($args['text']),
            'form_id'         => sanitize_text_field($args['form_id']),
            'is_special'      => $args['is_special'],
            'is_ignored'      => $args['is_ignored'],
            'count'           => sanitize_text_field($args['count']),
            'updated_at'      => current_time('mysql'),
            'updated_at_gmt'  => current_time('mysql', 1),
         ], [
            'id'              => $get_keyword->id
         ]);

         // Update all keyword dailies by keyword text.
         $wpdb->update("{$wpdb->prefix}wfs_search_keywords_daily", [
            'text'         => sanitize_text_field($args['text']),
            'form_id'      => sanitize_text_field($args['form_id']),
            'is_ignored'   => $args['is_ignored'],
         ], [
            'text'         => $get_keyword->text
         ]);

         return (int) $edit_keyword;
      }

      public static function delete_search_keyword(int $id)
      {
         global $wpdb;

         $delete = $wpdb->delete("{$wpdb->prefix}wfs_search_keywords", [
            'id' => intval($id)
         ]);

         return $delete;
      }

      public static function delete_search_keywords(string $ids)
      {
         global $wpdb;

         $search_keywords = $wpdb->query("DELETE FROM {$wpdb->prefix}wfs_search_keywords WHERE `id` IN($ids)");

         return (int) $search_keywords;
      }

      public static function make_search_keywords_special(string $ids)
      {
         global $wpdb;

         $search_keywords = $wpdb->query("UPDATE {$wpdb->prefix}wfs_search_keywords SET `is_special` = '1' WHERE `id` IN($ids)");

         return (int) $search_keywords;
      }

      public static function make_search_keywords_out_of_special(string $ids)
      {
         global $wpdb;

         $search_keywords = $wpdb->query("UPDATE {$wpdb->prefix}wfs_search_keywords SET `is_special` = '0' WHERE `id` IN($ids)");

         return (int) $search_keywords;
      }

      public static function make_search_keywords_ignore(string $ids)
      {
         global $wpdb;

         $search_keywords = $wpdb->query("UPDATE {$wpdb->prefix}wfs_search_keywords SET `is_ignored` = '1' WHERE `id` IN($ids)");

         return (int) $search_keywords;
      }

      public static function make_search_keywords_out_of_ignore(string $ids)
      {
         global $wpdb;

         $search_keywords = $wpdb->query("UPDATE {$wpdb->prefix}wfs_search_keywords SET `is_ignored` = '0' WHERE `id` IN($ids)");

         return (int) $search_keywords;
      }

      public static function delete_form(int $id)
      {
         $form_data = self::get_form($id);

         if ($form_data == false) {
            return false;
         }

         global $wpdb;

         $form = $wpdb->delete($wpdb->prefix . 'wfs_search_forms', [
            'id' => $id
         ]);

         return (int) $form;
      }

      public static function delete_forms(string $ids)
      {
         global $wpdb;

         $search_forms = $wpdb->query("DELETE FROM {$wpdb->prefix}wfs_search_forms WHERE `id` IN($ids)");

         return (int) $search_forms;
      }

      public static function update_form(int $id, array $arguments)
      {
         if (empty($arguments)) {
            return false;
         }

         global $wpdb;

         $update = [
            'updated_at'      => current_time('mysql'),
            'updated_at_gmt'  => current_time('mysql', 1),
         ];

         if (isset($arguments['title'])) {
            $update['title'] = sanitize_text_field($arguments['title']);
         }

         if (isset($arguments['status']) && in_array($arguments['status'], ['public', 'private', 'disable'])) {
            $update['status'] = $arguments['status'];
         }

         $wpdb->update($wpdb->prefix . 'wfs_search_forms', $update, [
            'id' => $id,
         ]);

         return true;
      }

      public static function update_form_option(int $id, array $arguments)
      {
         if (empty($arguments)) {
            return false;
         }

         global $wpdb;

         $form = self::get_form($id);

         if (!$form) {
            return false;
         }

         foreach ($arguments as $argument_key => $argument) {
            $form->form_options[$argument_key] = $argument;
         }

         $form_options_to_json = wp_json_encode($form->form_options);

         if (!$form_options_to_json) {
            return false;
         }

         $update = [
            'form_options'    => $form_options_to_json,
            'updated_at'      => current_time('mysql'),
            'updated_at_gmt'  => current_time('mysql', 1),
         ];

         $update = $wpdb->update($wpdb->prefix . 'wfs_search_forms', $update, [
            'id' => $id,
         ]);

         return $update;
      }

      public static function insert_form(string $title, string $status)
      {
         if (!in_array($status, [
            'public',
            'private',
            'disable',
         ])) {
            return false;
         }

         global $wpdb;

         $form_options           = self::get_form_options_seeding();
         $form_options_to_json   = wp_json_encode($form_options);

         if (!$form_options_to_json) {
            return false;
         }

         $insert_form = $wpdb->insert("{$wpdb->prefix}wfs_search_forms", [
            'title'           => sanitize_text_field($title),
            'status'          => $status,
            'form_options'    => $form_options_to_json,
            'created_at'      => current_time('mysql'),
            'created_at_gmt'  => current_time('mysql', 1),
            'updated_at'      => current_time('mysql'),
            'updated_at_gmt'  => current_time('mysql', 1),
         ]);

         if (is_wp_error($insert_form)) {
            wp_die($insert_form->get_error_message());
         }

         return $wpdb->insert_id;
      }

      public static function get_form_options_general_seeding()
      {
         return [
            // Search form
            'input_placeholder'              => __('Search...', 'webafra-fara-search'),
            'input_keyup_delay'              => '500',
            'form_icon'                      => '',
            'search_autocomplete'            => '0',
            'search_autocomplete_by'         => 'keywords',

            'search_result_post_types'             => class_exists('woocommerce') ? 'post,product' : 'post',
            'default_post_type'                    => class_exists('woocommerce') ? 'product' : 'post',
            'show_post_type_product_results_price' => class_exists('woocommerce') ? 1 : 0,
            'show_post_type_select'                => '0',
            'post_type_select_location'            => 'left',
            'taxonomy_dropdown'                    => 'category',
            'dropdown_source'                      => 'post_type',

            'layout'                               => 'simple',
            'layout_popup_type'                    => 'normal',
            'layout_popup_action_button'           => 'none',
            'layout_popup_action_button_icon'      => '',
            'layout_popup_action_button_text'      => '',
            'layout_popup_button_tooltip_text'     => '',
            'layout_popup_action_class'            => '',

            'use_other_search_results_page'  => 0,
            'form_submit_redirect_to'        => null,
            'form_submit_redirect_to_slug'   => null,
            'search_query_var'               => 's',
            'post_type_query_var'            => 'post_type',
            'category_query_var'             => 'category_id',

            // Search result
            'search_result_limit'                  => '5',
            'search_result_title_limit'            => '20',
            'search_result_carousel'               => '1',
            'search_result_carousel_limit'         => '3',
            'search_result_carousel_limit_tablet'  => '2',
            'search_result_carousel_limit_mobile'  => '1',
            'search_result_icon'                   => '',

            'search_in_post_type_categories'             => 0,
            'search_in_post_type_categories_title'       => __('Categories results', 'webafra-fara-search'),
            'search_in_post_type_categories_limit'       => '5',
            'search_in_post_type_categories_hide_empty'  => 0,
            'search_in_post_type_categories_exclude_tax' => '',
            'search_in_post_type_categories_icon'        => '',

            'settings_related_limit'   => '5',
            'settings_related_icon'    => '',

            // Search banner
            'search_banner_enable'     => '0',
            'search_banner_image'      => '',
            'search_banner_image_size' => 'large',
            'search_banner_url'        => '',

            // User last searches
            'user_last_searches_enable'   => '1',
            'user_last_searches_title'    => __('Your last searches', 'webafra-fara-search'),
            'user_last_searches_icon'     => '',

            // Papular searches
            'papular_searches_enable'        => '1',
            'papular_searches_title'         => __('Hot searches', 'webafra-fara-search'),
            'papular_searches_range_start'   => '7',
            'papular_searches_icon'          => '',

            // Suggested categories
            'suggested_categories_enable' => '0',
            'suggested_categories_title'  => __('Suggested categories', 'webafra-fara-search'),
            'suggested_categories_ids'    => '',
            'suggested_categories_icon'   => '',
         ];
      }

      public static function get_form_options_styles_seeding()
      {
         return [
            // Style: Form
            'style_overlay_enable'                    => '1',
            'style_overlay_color'                     => 'rgba(0,0,0,0.6)',

            'layout_popup_type_floating_position'           => 'right_top',
            'layout_popup_type_floating_right_left'         => '20',
            'layout_popup_type_floating_right_left_tablet'  => '20',
            'layout_popup_type_floating_right_left_mobile'  => '20',
            'layout_popup_type_floating_top_bottom'         => '20',
            'layout_popup_type_floating_top_bottom_tablet'  => '20',
            'layout_popup_type_floating_top_bottom_mobile'  => '20',

            'layout_popup_action_button_position'           => 'right_top',
            'layout_popup_action_button_right_left'         => '20',
            'layout_popup_action_button_right_left_tablet'  => '20',
            'layout_popup_action_button_right_left_mobile'  => '20',
            'layout_popup_action_button_top_bottom'         => '20',
            'layout_popup_action_button_top_bottom_tablet'  => '20',
            'layout_popup_action_button_top_bottom_mobile'  => '20',

            'layout_popup_action_button_text_font_size'        => '14',
            'layout_popup_action_button_text_font_size_tablet' => '14',
            'layout_popup_action_button_text_font_size_mobile' => '14',

            'layout_popup_action_button_text_color'         => '#ffffff',
            'layout_popup_action_button_background_color'   => '#0094DD',

            'layout_popup_action_button_border_radius'         => '10',
            'layout_popup_action_button_border_radius_tablet'  => '10',
            'layout_popup_action_button_border_radius_mobile'  => '10',

            'layout_popup_action_button_padding_left'          => '10',
            'layout_popup_action_button_padding_bottom'        => '10',
            'layout_popup_action_button_padding_right'         => '10',
            'layout_popup_action_button_padding_top'           => '10',
            'layout_popup_action_button_padding_left_tablet'   => '10',
            'layout_popup_action_button_padding_bottom_tablet' => '10',
            'layout_popup_action_button_padding_right_tablet'  => '10',
            'layout_popup_action_button_padding_top_tablet'    => '10',
            'layout_popup_action_button_padding_left_mobile'   => '10',
            'layout_popup_action_button_padding_bottom_mobile' => '10',
            'layout_popup_action_button_padding_right_mobile'  => '10',
            'layout_popup_action_button_padding_top_mobile'    => '10',

            'style_form_icon_color'                   => '#000000',
            'style_form_icon_size'                    => '20',
            'style_form_icon_size_tablet'             => '20',
            'style_form_icon_size_mobile'             => '20',
            'style_form_icon_position'                => 'row',
            'style_form_icon_padding_left'            => '10',
            'style_form_icon_padding_bottom'          => '10',
            'style_form_icon_padding_right'           => '10',
            'style_form_icon_padding_top'             => '10',
            'style_form_icon_padding_left_tablet'     => '10',
            'style_form_icon_padding_bottom_tablet'   => '10',
            'style_form_icon_padding_right_tablet'    => '10',
            'style_form_icon_padding_top_tablet'      => '10',
            'style_form_icon_padding_left_mobile'     => '10',
            'style_form_icon_padding_bottom_mobile'   => '10',
            'style_form_icon_padding_right_mobile'    => '10',
            'style_form_icon_padding_top_mobile'      => '10',
            'style_form_text_color'                   => '#81858b',
            'style_form_font_size'                    => '13',
            'style_form_font_size_tablet'             => '13',
            'style_form_font_size_mobile'             => '13',
            'style_form_background_color'             => '#ffffff',
            'style_form_border_color'                 => '#e1e1e1',
            'style_form_border_width_left'            => '1',
            'style_form_border_width_bottom'          => '1',
            'style_form_border_width_right'           => '1',
            'style_form_border_width_top'             => '1',
            'style_form_border_width_left_tablet'     => '1',
            'style_form_border_width_bottom_tablet'   => '1',
            'style_form_border_width_right_tablet'    => '1',
            'style_form_border_width_top_tablet'      => '1',
            'style_form_border_width_left_mobile'     => '1',
            'style_form_border_width_bottom_mobile'   => '1',
            'style_form_border_width_right_mobile'    => '1',
            'style_form_border_width_top_mobile'      => '1',
            'style_form_border_radius_top_right'            => '10',
            'style_form_border_radius_top_left'             => '10',
            'style_form_border_radius_bottom_right'         => '10',
            'style_form_border_radius_bottom_left'          => '10',
            'style_form_border_radius_top_right_tablet'     => '10',
            'style_form_border_radius_top_left_tablet'      => '10',
            'style_form_border_radius_bottom_right_tablet'  => '10',
            'style_form_border_radius_bottom_left_tablet'   => '10',
            'style_form_border_radius_top_right_mobile'     => '10',
            'style_form_border_radius_top_left_mobile'      => '10',
            'style_form_border_radius_bottom_right_mobile'  => '10',
            'style_form_border_radius_bottom_left_mobile'   => '10',
            'style_form_padding_left'                 => '15',
            'style_form_padding_bottom'               => '10',
            'style_form_padding_right'                => '15',
            'style_form_padding_top'                  => '10',
            'style_form_padding_left_tablet'          => '15',
            'style_form_padding_bottom_tablet'        => '10',
            'style_form_padding_right_tablet'         => '15',
            'style_form_padding_top_tablet'           => '10',
            'style_form_padding_left_mobile'          => '15',
            'style_form_padding_bottom_mobile'        => '10',
            'style_form_padding_right_mobile'         => '15',
            'style_form_padding_top_mobile'           => '10',

            // Post type select
            'style_search_form_post_type_select_text_color'                         => '#81858b',
            'style_search_form_post_type_select_font_size'                          => '13',
            'style_search_form_post_type_select_font_size_tablet'                   => '13',
            'style_search_form_post_type_select_font_size_mobile'                   => '13',
            'style_search_form_post_type_select_background_color'                   => '#ffffff',
            'style_search_form_post_type_select_border_color'                       => '#e1e1e1',
            'style_search_form_post_type_select_border_width_left'                  => '0',
            'style_search_form_post_type_select_border_width_bottom'                => '0',
            'style_search_form_post_type_select_border_width_right'                 => '1',
            'style_search_form_post_type_select_border_width_top'                   => '0',
            'style_search_form_post_type_select_border_width_left_tablet'           => '0',
            'style_search_form_post_type_select_border_width_bottom_tablet'         => '0',
            'style_search_form_post_type_select_border_width_right_tablet'          => '1',
            'style_search_form_post_type_select_border_width_top_tablet'            => '0',
            'style_search_form_post_type_select_border_width_left_mobile'           => '0',
            'style_search_form_post_type_select_border_width_bottom_mobile'         => '0',
            'style_search_form_post_type_select_border_width_right_mobile'          => '1',
            'style_search_form_post_type_select_border_width_top_mobile'            => '0',
            'style_search_form_post_type_select_border_radius_top_right'            => '0',
            'style_search_form_post_type_select_border_radius_top_left'             => '0',
            'style_search_form_post_type_select_border_radius_bottom_right'         => '0',
            'style_search_form_post_type_select_border_radius_bottom_left'          => '0',
            'style_search_form_post_type_select_border_radius_top_right_tablet'     => '0',
            'style_search_form_post_type_select_border_radius_top_left_tablet'      => '0',
            'style_search_form_post_type_select_border_radius_bottom_right_tablet'  => '0',
            'style_search_form_post_type_select_border_radius_bottom_left_tablet'   => '0',
            'style_search_form_post_type_select_border_radius_top_right_mobile'     => '0',
            'style_search_form_post_type_select_border_radius_top_left_mobile'      => '0',
            'style_search_form_post_type_select_border_radius_bottom_right_mobile'  => '0',
            'style_search_form_post_type_select_border_radius_bottom_left_mobile'   => '0',
            'style_search_form_post_type_select_padding_left'                       => '15',
            'style_search_form_post_type_select_padding_bottom'                     => '10',
            'style_search_form_post_type_select_padding_right'                      => '15',
            'style_search_form_post_type_select_padding_top'                        => '10',
            'style_search_form_post_type_select_padding_left_tablet'                => '15',
            'style_search_form_post_type_select_padding_bottom_tablet'              => '10',
            'style_search_form_post_type_select_padding_right_tablet'               => '15',
            'style_search_form_post_type_select_padding_top_tablet'                 => '10',
            'style_search_form_post_type_select_padding_left_mobile'                => '15',
            'style_search_form_post_type_select_padding_bottom_mobile'              => '10',
            'style_search_form_post_type_select_padding_right_mobile'               => '15',
            'style_search_form_post_type_select_padding_top_mobile'                 => '10',
            'style_search_form_post_type_select_margin_left'                       => '15',
            'style_search_form_post_type_select_margin_bottom'                     => '0',
            'style_search_form_post_type_select_margin_right'                      => '0',
            'style_search_form_post_type_select_margin_top'                        => '0',
            'style_search_form_post_type_select_margin_left_tablet'                => '15',
            'style_search_form_post_type_select_margin_bottom_tablet'              => '0',
            'style_search_form_post_type_select_margin_right_tablet'               => '0',
            'style_search_form_post_type_select_margin_top_tablet'                 => '0',
            'style_search_form_post_type_select_margin_left_mobile'                => '15',
            'style_search_form_post_type_select_margin_bottom_mobile'              => '0',
            'style_search_form_post_type_select_margin_right_mobile'               => '0',
            'style_search_form_post_type_select_margin_top_mobile'                 => '0',

            'style_search_form_post_type_select_hide_on_tablet' => 'block',
            'style_search_form_post_type_select_hide_on_mobile' => 'block',

            // Style: Search result
            'style_result_box_max_height'                   => '400',
            'style_result_box_max_height_tablet'            => '400',
            'style_result_box_max_height_mobile'            => '400',
            'style_result_box_background_color'             => '#ffffff',
            'style_result_box_border_color'                 => '#e1e1e1',
            'style_result_box_border_width_left'            => '0',
            'style_result_box_border_width_bottom'          => '0',
            'style_result_box_border_width_right'           => '0',
            'style_result_box_border_width_top'             => '0',
            'style_result_box_border_width_left_tablet'     => '0',
            'style_result_box_border_width_bottom_tablet'   => '0',
            'style_result_box_border_width_right_tablet'    => '0',
            'style_result_box_border_width_top_tablet'      => '0',
            'style_result_box_border_width_left_mobile'     => '0',
            'style_result_box_border_width_bottom_mobile'   => '0',
            'style_result_box_border_width_right_mobile'    => '0',
            'style_result_box_border_width_top_mobile'      => '0',
            'style_result_box_border_radius_top_right'            => '10',
            'style_result_box_border_radius_top_left'             => '10',
            'style_result_box_border_radius_bottom_right'         => '10',
            'style_result_box_border_radius_bottom_left'          => '10',
            'style_result_box_border_radius_top_right_tablet'     => '10',
            'style_result_box_border_radius_top_left_tablet'      => '10',
            'style_result_box_border_radius_bottom_right_tablet'  => '10',
            'style_result_box_border_radius_bottom_left_tablet'   => '10',
            'style_result_box_border_radius_top_right_mobile'     => '10',
            'style_result_box_border_radius_top_left_mobile'      => '10',
            'style_result_box_border_radius_bottom_right_mobile'  => '10',
            'style_result_box_border_radius_bottom_left_mobile'   => '10',

            'style_result_box_padding_left'                 => '15',
            'style_result_box_padding_bottom'               => '15',
            'style_result_box_padding_right'                => '15',
            'style_result_box_padding_top'                  => '15',
            'style_result_box_padding_left_tablet'          => '15',
            'style_result_box_padding_bottom_tablet'        => '15',
            'style_result_box_padding_right_tablet'         => '15',
            'style_result_box_padding_top_tablet'           => '15',
            'style_result_box_padding_left_mobile'          => '15',
            'style_result_box_padding_bottom_mobile'        => '15',
            'style_result_box_padding_right_mobile'         => '15',
            'style_result_box_padding_top_mobile'           => '15',
            'style_result_box_e_padding_top'                => '0',
            'style_result_box_e_padding_top_tablet'         => '0',
            'style_result_box_e_padding_top_mobile'         => '0',
            'style_result_box_margin_left'                  => '0',
            'style_result_box_margin_bottom'                => '0',
            'style_result_box_margin_right'                 => '0',
            'style_result_box_margin_top'                   => '0',
            'style_result_box_margin_left_tablet'           => '0',
            'style_result_box_margin_bottom_tablet'         => '0',
            'style_result_box_margin_right_tablet'          => '0',
            'style_result_box_margin_top_tablet'            => '0',
            'style_result_box_margin_left_mobile'           => '0',
            'style_result_box_margin_bottom_mobile'         => '0',
            'style_result_box_margin_right_mobile'          => '0',
            'style_result_box_margin_top_mobile'            => '0',

            'style_search_result_item_icon_color'              => '#a1a3a8',
            'style_search_result_item_icon_size'               => '22',
            'style_search_result_item_icon_size_tablet'        => '22',
            'style_search_result_item_icon_size_mobile'        => '22',
            'style_search_result_item_link_color'              => '#000000',
            'style_search_result_item_link_hover_color'        => '#000000',
            'post_type_product_results_price_color'            => '#152A5D',
            'style_search_result_item_link_font_size'          => '14',
            'style_search_result_item_link_font_size_tablet'   => '14',
            'style_search_result_item_link_font_size_mobile'   => '14',
            'post_type_product_results_price_font_size'            => '13',
            'post_type_product_results_price_font_size_tablet'     => '13',
            'post_type_product_results_price_font_size_mobile'     => '13',
            'style_search_result_item_spacing'                 => '10',
            'style_search_result_item_spacing_tablet'          => '10',
            'style_search_result_item_spacing_mobile'          => '10',

            'style_related_result_icon_color'                  => '$a1a3a8',
            'style_related_result_icon_size'                   => '22',
            'style_related_result_icon_size_tablet'            => '22',
            'style_related_result_icon_size_mobile'            => '22',
            'style_related_result_link_color'                  => '#000000',
            'style_related_result_link_hover_color'            => '#000000',
            'style_related_result_link_font_size'              => '14',
            'style_related_result_link_font_size_tablet'       => '14',
            'style_related_result_link_font_size_mobile'       => '14',
            'style_related_result_item_spacing'                => '14',
            'style_related_result_item_spacing_tablet'         => '14',
            'style_related_result_item_spacing_mobile'         => '14',
            'style_related_result_border_color'                => '#e0e0e6',
            'style_related_result_border_width_left'           => '0',
            'style_related_result_border_width_bottom'         => '0',
            'style_related_result_border_width_right'          => '0',
            'style_related_result_border_width_top'            => '1',
            'style_related_result_border_width_left_tablet'    => '0',
            'style_related_result_border_width_bottom_tablet'  => '0',
            'style_related_result_border_width_right_tablet'   => '0',
            'style_related_result_border_width_top_tablet'     => '1',
            'style_related_result_border_width_left_mobile'    => '0',
            'style_related_result_border_width_bottom_mobile'  => '0',
            'style_related_result_border_width_right_mobile'   => '0',
            'style_related_result_border_width_top_mobile'     => '1',

            'style_sr_ci_background'                  => '#ffffff',
            'style_sr_ci_border_color'                => '#f0f0f1',
            'style_sr_ci_border_width_left'           => '1',
            'style_sr_ci_border_width_bottom'         => '1',
            'style_sr_ci_border_width_right'          => '1',
            'style_sr_ci_border_width_top'            => '1',
            'style_sr_ci_border_width_left_tablet'    => '1',
            'style_sr_ci_border_width_bottom_tablet'  => '1',
            'style_sr_ci_border_width_right_tablet'   => '1',
            'style_sr_ci_border_width_top_tablet'     => '1',
            'style_sr_ci_border_width_left_mobile'    => '1',
            'style_sr_ci_border_width_bottom_mobile'  => '1',
            'style_sr_ci_border_width_right_mobile'   => '1',
            'style_sr_ci_border_width_top_mobile'     => '1',
            'style_sr_ci_border_radius'               => '5',
            'style_sr_ci_border_radius_tablet'        => '5',
            'style_sr_ci_border_radius_mobile'        => '5',
            'style_sr_ci_thumbnail_height'            => '50',
            'style_sr_ci_thumbnail_height_tablet'     => '50',
            'style_sr_ci_thumbnail_height_mobile'     => '50',
            'style_sr_ci_padding_left'                => '5',
            'style_sr_ci_padding_bottom'              => '5',
            'style_sr_ci_padding_right'               => '5',
            'style_sr_ci_padding_top'                 => '5',
            'style_sr_ci_padding_left_tablet'         => '5',
            'style_sr_ci_padding_bottom_tablet'       => '5',
            'style_sr_ci_padding_right_tablet'        => '5',
            'style_sr_ci_padding_top_tablet'          => '5',
            'style_sr_ci_padding_left_mobile'         => '5',
            'style_sr_ci_padding_bottom_mobile'       => '5',
            'style_sr_ci_padding_right_mobile'        => '5',
            'style_sr_ci_padding_top_mobile'          => '5',

            'style_user_last_searches_icon_color'                    => '#a1a3a8',
            'style_user_last_searches_icon_size'                     => '22',
            'style_user_last_searches_icon_size_tablet'              => '22',
            'style_user_last_searches_icon_size_mobile'              => '22',
            'style_user_last_searches_heading_color'                 => '#3f4064',
            'style_user_last_searches_heading_font_size'             => '16',
            'style_user_last_searches_heading_font_size_tablet'      => '16',
            'style_user_last_searches_heading_font_size_mobile'      => '16',
            'style_user_last_searches_heading_margin_bottom'         => '15',
            'style_user_last_searches_heading_margin_bottom_tablet'  => '15',
            'style_user_last_searches_heading_margin_bottom_mobile'  => '15',
            'style_user_last_searches_item_link_color'               => '#3f4064',
            'style_user_last_searches_item_link_hover_color'         => '#3f4064',
            'style_user_last_searches_item_link_arrow_color'         => '#000000',
            'style_user_last_searches_item_link_arrow_hover_color'   => '#000000',
            'style_user_last_searches_item_link_font_size'           => '14',
            'style_user_last_searches_item_link_font_size_tablet'    => '14',
            'style_user_last_searches_item_link_font_size_mobile'    => '14',
            'style_user_last_searches_item_border_radius'            => '30',
            'style_user_last_searches_item_border_radius_tablet'     => '30',
            'style_user_last_searches_item_border_radius_mobile'     => '30',
            'style_user_last_searches_padding_left'                  => '15',
            'style_user_last_searches_padding_bottom'                => '15',
            'style_user_last_searches_padding_right'                 => '15',
            'style_user_last_searches_padding_top'                   => '15',
            'style_user_last_searches_padding_left_tablet'           => '15',
            'style_user_last_searches_padding_bottom_tablet'         => '15',
            'style_user_last_searches_padding_right_tablet'          => '15',
            'style_user_last_searches_padding_top_tablet'            => '15',
            'style_user_last_searches_padding_left_mobile'           => '15',
            'style_user_last_searches_padding_bottom_mobile'         => '15',
            'style_user_last_searches_padding_right_mobile'          => '15',
            'style_user_last_searches_padding_top_mobile'            => '15',

            'style_papular_searches_icon_color'                    => '#a1a3a8',
            'style_papular_searches_icon_size'                     => '22',
            'style_papular_searches_icon_size_tablet'              => '22',
            'style_papular_searches_icon_size_mobile'              => '22',
            'style_papular_searches_heading_color'                 => '#3f4064',
            'style_papular_searches_heading_font_size'             => '16',
            'style_papular_searches_heading_font_size_tablet'      => '16',
            'style_papular_searches_heading_font_size_mobile'      => '16',
            'style_papular_searches_heading_margin_bottom'           => '15',
            'style_papular_searches_heading_margin_bottom_tablet'    => '15',
            'style_papular_searches_heading_margin_bottom_mobile'    => '15',
            'style_papular_searches_item_link_color'               => '#3f4064',
            'style_papular_searches_item_link_hover_color'         => '#3f4064',
            'style_papular_searches_item_link_arrow_color'         => '#000000',
            'style_papular_searches_item_link_arrow_hover_color'   => '#000000',
            'style_papular_searches_item_link_font_size'           => '14',
            'style_papular_searches_item_link_font_size_tablet'    => '14',
            'style_papular_searches_item_link_font_size_mobile'    => '14',
            'style_papular_searches_item_border_radius'            => '30',
            'style_papular_searches_item_border_radius_tablet'     => '30',
            'style_papular_searches_item_border_radius_mobile'     => '30',
            'style_papular_searches_padding_left'                  => '15',
            'style_papular_searches_padding_bottom'                => '15',
            'style_papular_searches_padding_right'                 => '15',
            'style_papular_searches_padding_top'                   => '15',
            'style_papular_searches_padding_left_tablet'           => '15',
            'style_papular_searches_padding_bottom_tablet'         => '15',
            'style_papular_searches_padding_right_tablet'          => '15',
            'style_papular_searches_padding_top_tablet'            => '15',
            'style_papular_searches_padding_left_mobile'           => '15',
            'style_papular_searches_padding_bottom_mobile'         => '15',
            'style_papular_searches_padding_right_mobile'          => '15',
            'style_papular_searches_padding_top_mobile'            => '15',

            'style_suggested_categories_icon_color'                    => '#a1a3a8',
            'style_suggested_categories_icon_size'                     => '22',
            'style_suggested_categories_icon_size_tablet'              => '22',
            'style_suggested_categories_icon_size_mobile'              => '22',
            'style_suggested_categories_heading_color'                 => '#3f4064',
            'style_suggested_categories_heading_font_size'             => '16',
            'style_suggested_categories_heading_font_size_tablet'      => '16',
            'style_suggested_categories_heading_font_size_mobile'      => '16',
            'style_suggested_categories_heading_margin_bottom'          => '15',
            'style_suggested_categories_heading_margin_bottom_tablet'   => '15',
            'style_suggested_categories_heading_margin_bottom_mobile'   => '15',
            'style_suggested_categories_item_link_color'               => '#3f4064',
            'style_suggested_categories_item_link_hover_color'         => '#3f4064',
            'style_suggested_categories_item_link_arrow_color'         => '#000000',
            'style_suggested_categories_item_link_arrow_hover_color'   => '#000000',
            'style_suggested_categories_item_link_font_size'           => '14',
            'style_suggested_categories_item_link_font_size_tablet'    => '14',
            'style_suggested_categories_item_link_font_size_mobile'    => '14',
            'style_suggested_categories_item_border_radius'            => '30',
            'style_suggested_categories_item_border_radius_tablet'     => '30',
            'style_suggested_categories_item_border_radius_mobile'     => '30',
            'style_suggested_categories_padding_left'                  => '15',
            'style_suggested_categories_padding_bottom'                => '0',
            'style_suggested_categories_padding_right'                 => '15',
            'style_suggested_categories_padding_top'                   => '15',
            'style_suggested_categories_padding_left_tablet'           => '15',
            'style_suggested_categories_padding_bottom_tablet'         => '0',
            'style_suggested_categories_padding_right_tablet'          => '15',
            'style_suggested_categories_padding_top_tablet'            => '15',
            'style_suggested_categories_padding_left_mobile'           => '15',
            'style_suggested_categories_padding_bottom_mobile'         => '0',
            'style_suggested_categories_padding_right_mobile'          => '15',
            'style_suggested_categories_padding_top_mobile'            => '15',

            'style_banner_border_radius'           => '10',
            'style_banner_border_radius_tablet'    => '10',
            'style_banner_border_radius_mobile'    => '10',
            'style_banner_alignment'               => 'center',
            'style_banner_width'                   => '100',
            'style_banner_width_tablet'            => '100',
            'style_banner_width_mobile'            => '100',
            'style_banner_height'                  => '',
            'style_banner_height_tablet'           => '',
            'style_banner_height_mobile'           => '',
            'style_banner_padding_left'            => '15',
            'style_banner_padding_bottom'          => '15',
            'style_banner_padding_right'           => '15',
            'style_banner_padding_top'             => '15',
            'style_banner_padding_left_tablet'     => '15',
            'style_banner_padding_bottom_tablet'   => '15',
            'style_banner_padding_right_tablet'    => '15',
            'style_banner_padding_top_tablet'      => '15',
            'style_banner_padding_left_mobile'     => '15',
            'style_banner_padding_bottom_mobile'   => '15',
            'style_banner_padding_right_mobile'    => '15',
            'style_banner_padding_top_mobile'      => '15',
         ];
      }

      public static function get_form_options_seeding()
      {
         $general = self::get_form_options_general_seeding();
         $styles = self::get_form_options_styles_seeding();

         return array_merge($general, $styles);
      }

      public static function get_form(int $id)
      {
         global $wpdb;

         $form_data = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}wfs_search_forms WHERE id = %d", $id));

         if (is_null($form_data)) {
            return false;
         }

         $form_data->form_options = json_decode($form_data->form_options, true);

         return (object) $form_data;
      }

      public static function get_forms_raw()
      {
         global $wpdb;

         $forms = $wpdb->get_results("SELECT id, title FROM {$wpdb->prefix}wfs_search_forms ORDER BY `title`");

         return $forms;
      }

      public static function get_search_forms(array $args = [])
      {
         global $wpdb;

         $args = wp_parse_args($args, [
            'wheres'    => [],
            'orderby'   => 'id',
            'order'     => 'DESC',
            'paged'     => 1,
            'per_pages' => 10,
         ]);

         $where = '';

         if (isset($args['wheres']) && (is_array($args['wheres']) && !empty($args['wheres']))) {
            foreach ($args['wheres'] as $filter_key => $filter) {
               if (!empty($filter)) {
                  if (gettype($where) == 'string') {
                     $where = [];
                  }

                  if ($filter_key == 'created_at' && !empty($filter)) {
                  } else {
                     $where[] = "{$filter_key} = '{$filter}'";
                  }
               }
            }

            if (!empty($where) && count($where) > 0) {
               $where = implode(' AND ', $where);
               $where = "WHERE {$where}";
            }
         }

         $total_query      = $wpdb->get_var("SELECT COUNT(*) FROM `{$wpdb->prefix}wfs_search_forms` {$where}");
         $total_pages      = ceil($total_query / $args['per_pages']);
         $starting_limit   = ($args['paged'] - 1) * $args['per_pages'];

         $sql = "SELECT * FROM `{$wpdb->prefix}wfs_search_forms` $where ORDER BY {$args['orderby']} {$args['order']} LIMIT {$starting_limit}, {$args['per_pages']}";

         return (object) [
            'data'         => $wpdb->get_results($sql),
            'total_page'   => $total_pages,
            'total_item'   => $total_query,
         ];
      }

      public static function get_search_logs(array $args = [])
      {
         global $wpdb;

         $args = wp_parse_args($args, [
            'wheres'    => [],
            'orderby'   => 'id',
            'order'     => 'DESC',
            'paged'     => 1,
            'per_pages' => 10,
         ]);

         $where = '';

         if (isset($args['wheres']) && (is_array($args['wheres']) && !empty($args['wheres']))) {
            foreach ($args['wheres'] as $filter_key => $filter) {
               if (!empty($filter)) {
                  if (gettype($where) == 'string') {
                     $where = [];
                  }

                  if ($filter_key == 'created_at' && !empty($filter)) {
                     $filter_arr = explode(',', $filter);
                     if (!empty($filter_arr[0]) && !empty($filter_arr[1])) {
                        $start = str_replace('/', '-', $filter_arr[0]);
                        $end = str_replace('/', '-', $filter_arr[0]);
                        $where[] = "DATE(created_at) BETWEEN '{$start}' AND '{$end}'";
                     } elseif (!empty($filter_arr[0]) && empty($filter_arr[1])) {
                        $start = str_replace('/', '-', $filter_arr[0]);
                        $where[] = "DATE(created_at) >= '{$start}'";
                     } elseif (empty($filter_arr[0]) && !empty($filter_arr[1])) {
                        $end = str_replace('/', '-', $filter_arr[1]);
                        $where[] = "DATE(created_at) <= '{$end}'";
                     }
                  } elseif ($filter_key == 'search' && !empty($filter)) {
                     $filter = esc_attr(sanitize_text_field($filter));
                     $filter = trim($filter);

                     $mode = "";

                     if (mb_strlen($filter) <= 3) {
                        $mode = " IN BOOLEAN MODE";
                     }

                     $where[] = "MATCH (`text`) AGAINST ('{$filter}*'{$mode})";
                  } elseif ($filter_key == 'filter_by' && !empty($filter)) {
                     if ($filter == 'has_result') {
                        $where[] = "has_result = '1'";
                     } elseif ($filter == 'has_no_result') {
                        $where[] = "has_result = '0'";
                     }
                  } elseif (!in_array($filter_key, ['created_at', 'search', 'filter_by'])) {
                     $where[] = "{$filter_key} = '{$filter}'";
                  }
               }
            }

            if (!empty($where) && count($where) > 0) {
               $where = implode(' AND ', $where);
               $where = "WHERE {$where}";
            }
         }

         $total_query      = $wpdb->get_var("SELECT COUNT(*) FROM `{$wpdb->prefix}wfs_search_logs` {$where}");
         $total_pages      = ceil($total_query / $args['per_pages']);
         $starting_limit   = ($args['paged'] - 1) * $args['per_pages'];

         $sql = "SELECT * FROM `{$wpdb->prefix}wfs_search_logs` $where ORDER BY {$args['orderby']} {$args['order']} LIMIT {$starting_limit}, {$args['per_pages']}";

         return (object) [
            'data'         => $wpdb->get_results($sql),
            'total_page'   => $total_pages,
            'total_item'   => $total_query,
         ];
      }

      public static function get_top_search_texts_daily(int $form_id = null)
      {
         global $wpdb;

         if (is_numeric($form_id)) {
            $query = $wpdb->prepare(
               "SELECT * FROM `{$wpdb->prefix}wfs_search_keywords_daily` WHERE `form_id` = %d ORDER BY `date` ASC LIMIT 15",
               $form_id
            );
         } else {
            $query = "SELECT * FROM `{$wpdb->prefix}wfs_search_keywords_daily` ORDER BY `date` ASC LIMIT 15";
         }

         $texts = $wpdb->get_results($query);

         return (array) $texts;
      }

      public static function get_search_keywords(array $args = [])
      {
         global $wpdb;

         $args = wp_parse_args($args, [
            'wheres'    => [],
            'orderby'   => 'id',
            'order'     => 'DESC',
            'paged'     => 1,
            'per_pages' => 10,
         ]);

         $where = '';

         if (isset($args['wheres']) && (is_array($args['wheres']) && !empty($args['wheres']))) {
            foreach ($args['wheres'] as $filter_key => $filter) {
               if (!empty($filter)) {
                  if (gettype($where) == 'string') {
                     $where = [];
                  }

                  if ($filter_key == 'created_at' && !empty($filter)) {
                     $filter_arr = explode(',', $filter);
                     if (!empty($filter_arr[0]) && !empty($filter_arr[1])) {
                        $start = str_replace('/', '-', $filter_arr[0]);
                        $end = str_replace('/', '-', $filter_arr[0]);
                        $where[] = "DATE(created_at) BETWEEN '{$start}' AND '{$end}'";
                     } elseif (!empty($filter_arr[0]) && empty($filter_arr[1])) {
                        $start = str_replace('/', '-', $filter_arr[0]);
                        $where[] = "DATE(created_at) >= '{$start}'";
                     } elseif (empty($filter_arr[0]) && !empty($filter_arr[1])) {
                        $end = str_replace('/', '-', $filter_arr[1]);
                        $where[] = "DATE(created_at) <= '{$end}'";
                     }
                  } elseif ($filter_key == 'filter_by' && !empty($filter)) {
                     if ($filter == 'is_special') {
                        $where[] = "is_special = '1'";
                     } elseif ($filter == 'is_not_special') {
                        $where[] = "is_special = '0'";
                     } elseif ($filter == 'is_ignored') {
                        $where[] = "is_ignored = '1'";
                     } elseif ($filter == 'is_not_ignored') {
                        $where[] = "is_ignored = '0'";
                     } elseif ($filter == 'has_result') {
                        $where[] = "has_result = '1'";
                     } elseif ($filter == 'has_no_result') {
                        $where[] = "has_result = '0'";
                     }
                  } elseif ($filter_key == 'search' && !empty($filter)) {
                     $filter = esc_attr(sanitize_text_field($filter));
                     $filter = trim($filter);

                     $mode = "";

                     if (mb_strlen($filter) <= 3) {
                        $mode = " IN BOOLEAN MODE";
                     }

                     $where[] = "MATCH (`text`) AGAINST ('{$filter}*'{$mode})";
                  } elseif (!in_array($filter_key, ['created_at', 'filter_by', 'search'])) {
                     $where[] = "{$filter_key} = '{$filter}'";
                  }
               }
            }

            if (!empty($where) && count($where) > 0) {
               $where = implode(' AND ', $where);
               $where = "WHERE {$where}";
            }
         }

         $total_query      = $wpdb->get_var("SELECT COUNT(*) FROM `{$wpdb->prefix}wfs_search_keywords` {$where}");
         $total_pages      = ceil($total_query / $args['per_pages']);
         $starting_limit   = ($args['paged'] - 1) * $args['per_pages'];

         $sql = "SELECT * FROM `{$wpdb->prefix}wfs_search_keywords` $where ORDER BY {$args['orderby']} {$args['order']} LIMIT {$starting_limit}, {$args['per_pages']}";

         return (object) [
            'data'         => $wpdb->get_results($sql),
            'total_page'   => $total_pages,
            'total_item'   => $total_query,
         ];
      }

      public static function get_user_last_searches(int $limit = 10)
      {
         if (!get_current_user_id()) {
            return false;
         }

         global $wpdb;

         $prepare = $wpdb->prepare("SELECT * FROM `{$wpdb->prefix}wfs_search_user_logs` WHERE `user_id` = %d ORDER BY `updated_at` DESC LIMIT %d", get_current_user_id(), $limit);
         $result  = $wpdb->get_results($prepare);

         return $result;
      }

      public static function get_popular_searches(string $form_id, string $range_start, int $limit = 10)
      {
         if (empty($form_id)) {
            return false;
         }

         $transient_name = 'wfs_popular_searches_' . $form_id;

         // Create transient cache if there is not cache.
         if (!$get_popular_searches = get_transient($transient_name)) {
            $startDate  = date('Y-m-d', strtotime("-{$range_start} days", current_time('timestamp')));
            $endDate    = date('Y-m-d', strtotime("-1 days", current_time('timestamp')));

            global $wpdb;

            $prepare = $wpdb->prepare(
               "SELECT * FROM `{$wpdb->prefix}wfs_search_keywords_daily` WHERE `is_ignored` = 0 AND `has_result` = 1 AND `form_id` = %d AND (`date` >= %s OR `date` <= %s) ORDER BY `count` DESC LIMIT %d",
               $form_id,
               $startDate,
               $endDate,
               $limit
            );

            $results = $wpdb->get_results($prepare);

            set_transient($transient_name, $results, 60 * 60 * 24);

            return $results;
         }

         return $get_popular_searches;
      }

      public static function get_related_searches(int $form_id, string $search, int $limit = 10)
      {
         if (empty($search)) {
            return false;
         }

         global $wpdb;

         $mode = "";

         if (mb_strlen($search) <= 3) {
            $mode = " IN BOOLEAN MODE";
         }

         $result  = $wpdb->get_results(
            $wpdb->prepare(
               "SELECT * FROM `{$wpdb->prefix}wfs_search_keywords` WHERE `form_id` = %d AND `is_ignored` = 0 AND `has_result` = '1' AND MATCH (`text`) AGAINST ('%s'{$mode}) ORDER BY `is_special` DESC, `count` DESC, `id` DESC LIMIT %d",
               $form_id,
               "{$search}*",
               $limit
            )
         );

         return $result;
      }

      public static function get_all_related_searches(string $search, int $limit = 10)
      {
         if (empty($search)) {
            return false;
         }

         global $wpdb;

         $mode = "";

         if (mb_strlen($search) <= 3) {
            $mode = " IN BOOLEAN MODE";
         }

         $result  = $wpdb->get_results(
            $wpdb->prepare(
               "SELECT * FROM `{$wpdb->prefix}wfs_search_keywords` WHERE `is_ignored` = 0 AND `has_result` = '1' AND MATCH (`text`) AGAINST ('%s'{$mode}) ORDER BY `is_special` DESC, `count` DESC, `id` DESC LIMIT %d",
               "{$search}*",
               $limit
            )
         );

         return $result;
      }

      /**
       * Generate unique tracking code.
       *
       */
      public static function generate_tracking_code()
      {
         global $wpdb;

         $is_unique     = 0;
         $result_code   = null;

         while ($is_unique == 0) {
            $tracking_code = wac_generate_random_str(8);
            $checking = $wpdb->get_var(
               $wpdb->prepare(
                  "SELECT COUNT(*) FROM `{$wpdb->prefix}wfs_search_logs` WHERE `tracking_code` = %s",
                  $tracking_code
               )
            );

            if (!$checking) {
               $is_unique     = 1;
               $result_code   = $tracking_code;
               break;
            }
         }

         return $result_code;
      }
   }
}
