<?php
if (!defined('ABSPATH')) {
   exit;
}

global $wpdb;

$charset_collate = $wpdb->get_charset_collate();

require_once ABSPATH . 'wp-admin/includes/upgrade.php';

// Search Keywords
dbDelta("CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}wfs_search_keywords` (`id` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, `form_id` INT NOT NULL, `text` TEXT DEFAULT NULL, `has_result` TINYINT(1) DEFAULT 0, `count` INT DEFAULT 1, `is_special` TINYINT(1) DEFAULT 0, `is_ignored` TINYINT(1) DEFAULT 0, `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `created_at_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `updated_at_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', FULLTEXT (`text`)) {$charset_collate}");

// Search Keywords Daily
dbDelta("CREATE TABLE IF NOT EXISTS `{$wpdb->prefix}wfs_search_keywords_daily` (`id` INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, `form_id` INT NOT NULL, `text` TEXT DEFAULT NULL, `has_result` TINYINT(1) DEFAULT 0, `count` INT DEFAULT 1, `is_ignored` TINYINT(1) DEFAULT 0, `date` DATE NOT NULL, FULLTEXT (`text`), INDEX(`form_id`, `date`)) {$charset_collate}");

if (!class_exists('wfs_DB_Migrate')) {
   class wfs_DB_Migrate
   {
      public static $ins = null;

      public static function ins()
      {
         if (is_null(self::$ins)) {
            self::$ins = new self();
         }
         return self::$ins;
      }

      public function __construct()
      {
         require_once ABSPATH . 'wp-admin/includes/upgrade.php';

         $this->wfs_search_forms();
         $this->wfs_search_logs();
         $this->wfs_search_user_logs();
      }

      public function wfs_search_forms()
      {
         global $wpdb;

         $wfs_search_forms = sprintf(
            "CREATE TABLE IF NOT EXISTS `%s` (`id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, `title` VARCHAR(255) DEFAULT NULL, `status` VARCHAR(255) DEFAULT 'private', `form_options` LONGTEXT DEFAULT NULL, `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `created_at_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `updated_at_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00') %s",
            $wpdb->prefix . 'wfs_search_forms',
            $wpdb->get_charset_collate()
         );

         dbDelta($wfs_search_forms);
      }

      public function wfs_search_logs()
      {
         global $wpdb;

         $wfs_search_logs = sprintf(
            "CREATE TABLE IF NOT EXISTS `%s` (`id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, `form_id` BIGINT NOT NULL, `text` VARCHAR(255) DEFAULT NULL, `tracking_code` VARCHAR(25) DEFAULT NULL, `user_id` BIGINT NOT NULL, `has_result` BIGINT DEFAULT NULL, `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `created_at_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', FULLTEXT (`text`)) %s",
            $wpdb->prefix . 'wfs_search_logs',
            $wpdb->get_charset_collate()
         );

         dbDelta($wfs_search_logs);
      }

      public function wfs_search_user_logs()
      {
         global $wpdb;

         $wfs_search_user_logs = sprintf(
            "CREATE TABLE IF NOT EXISTS `%s` (`id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, `text` VARCHAR(255) DEFAULT NULL, `count` BIGINT DEFAULT 0, `user_id` BIGINT NOT NULL, `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `created_at_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00', `updated_at_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00') %s",
            $wpdb->prefix . 'wfs_search_user_logs',
            $wpdb->get_charset_collate()
         );

         dbDelta($wfs_search_user_logs);
      }
   }

   wfs_DB_Migrate::ins();
}
