<?php
if (!defined('ABSPATH')) {
   die;
}

if (!class_exists('WFS_Ajax')) {
   class WFS_Ajax
   {
      public static $ins = null;

      public static function ins()
      {
         if (is_null(self::$ins)) {
            self::$ins = new self();
         }

         return self::$ins;
      }

      public function __construct()
      {
         add_action('init', [$this, 'custom_ajax']);

         // add_action('wp_ajax_wfs_getting_result', [$this, 'ajax_load']);
         // add_action('wp_ajax_nopriv_wfs_getting_result', [$this, 'ajax_load']);
         // add_action('wp_ajax_wfs_getting_related', [$this, 'ajax_load_search_related']);
         // add_action('wp_ajax_nopriv_wfs_getting_related', [$this, 'ajax_load_search_related']);
         // add_action('wp_ajax_wfs_clear_user_searches', [$this, 'ajax_clear_user_searches']);

         // Panel:
         add_action('wp_ajax_wfs_getting_terms', [$this, 'ajax_getting_terms']);
      }

      public function custom_ajax()
      {
         if (isset($_GET['wfs-ajax']) && !empty($_GET['wfs-ajax'])) {
            if ($_GET['wfs-ajax'] == 'ajax_load') {
               $this->ajax_load();
               exit;
            }
            if ($_GET['wfs-ajax'] == 'getting_related') {
               $this->ajax_load_search_related();
               exit;
            }
         }
      }

      public function ajax_load()
      {
         header('Content-Type: application/json; charset=utf-8');

         if (!wp_verify_nonce($_POST['nonce'], 'wfs-ajax-nonce')) {
            echo wp_json_encode([
               'status'             => 'error',
               'html'               => '<div class="search-no-result">' . __('Nonce is invalid', 'webafra-fara-search') . '!</div>',
               'tracking_code'      => '',
               'has_result'         => 0,
               'user_last_search'   => [],
            ]);
            exit;
         }

         if (!isset($_POST['keyword']) || (isset($_POST['keyword']) && empty($_POST['keyword']))) {
            echo wp_json_encode([
               'status'          => 'error',
               'html'            => '<div class="search-no-result">' . __('Keyword is missing', 'webafra-fara-search') . '!</div>',
               'tracking_code'   => '',
               'has_result'      => 0,
               'user_last_search'   => [],
            ]);
            exit;
         }

         if (!isset($_POST['form_id']) || !is_numeric($_POST['form_id'])) {
            echo wp_json_encode([
               'status'             => 'error',
               'html'               => '<div class="search-no-result">' . __('Form id is missing', 'webafra-fara-search') . '!</div>',
               'tracking_code'      => '',
               'has_result'         => 0,
               'user_last_search'   => [],
            ]);
            exit;
         }

         $file = wfs_PP . "/backups/form-settings-{$_POST['form_id']}.json";

         if (!file_exists($file)) {
            $form = WFS_DB_Queries::get_form((int) $_POST['form_id']);
            $form_options = $form->form_options;
         } else {
            $get_json      = file_get_contents($file);
            $form_options  = json_decode($get_json, true);
         }

         $result = [
            'status'                => 'ok',
            'html'                  => '',
            'terms_search_results'  => '',
            'tracking_code'         => '',
            'has_result'            => 0,
            'user_last_search'      => [],
            'search_autocomplete'   => '',
         ];

         $keyword = esc_attr(sanitize_text_field(wfs_convert_arabic_string_to_persian($_POST['keyword'])));
         $keyword = trim($keyword);

         $search_result_limit = 5;

         if (isset($form_options['search_result_limit']) && is_numeric($form_options['search_result_limit'])) {
            $search_result_limit = (int) $form_options['search_result_limit'];
         }

         $args = [
            'posts_per_page'  => $search_result_limit,
            's'               => $keyword
         ];

         $post_types = null;
         $is_product_post_type = 0;

         if (isset($_POST['post_type_select']) && !empty($_POST['post_type_select'])) {
            $post_types = [$_POST['post_type_select']];
            $args['post_type'] = $post_types;

            if ($post_types == 'product') {
               $is_product_post_type = 1;
            }
         } elseif (isset($_POST['category_select']) && !empty($_POST['category_select'])) {
            $args['tax_query'] = [
               [
                  'taxonomy'  => $form_options['taxonomy_dropdown'],
                  'field'     => 'term_id',
                  'terms'     => (int) $_POST['category_select']
               ]
            ];
         } elseif (isset($form_options['search_result_post_types']) && !empty($form_options['search_result_post_types'])) {
            $post_types = explode(',', $form_options['search_result_post_types']);
            $args['post_type'] = $post_types;

            if (in_array('product', $post_types)) {
               $is_product_post_type = 1;
            }
         }

         if (!is_null($post_types)) {
            // Search in product sku.
            if ($is_product_post_type) {
               global $wpdb;

               $search_by_sku = $wpdb->get_row($wpdb->prepare("SELECT `post_id` FROM {$wpdb->prefix}postmeta WHERE `meta_key` = '_sku' AND `meta_value` = %s", $keyword));
               if (!is_null($search_by_sku)) {
                  unset($args['s']);
                  $args['post__in'] = [$search_by_sku->post_id];
               }
            }

            // here we checked and have post type so we can search in term names.
            if (isset($form_options['search_in_post_type_categories']) && $form_options['search_in_post_type_categories'] == '1') {
               $post_type_taxonomies = [];

               foreach ($post_types as $post_type) {
                  $post_type_taxonomies_check = get_taxonomies([
                     'object_type' => [$post_type]
                  ]);

                  if (!empty($post_type_taxonomies_check)) {
                     $post_type_taxonomies = array_merge($post_type_taxonomies, array_keys($post_type_taxonomies_check));
                  }
               }

               if (!empty($post_type_taxonomies)) {
                  if (isset($form_options['search_in_post_type_categories_exclude_tax']) && !empty($form_options['search_in_post_type_categories_exclude_tax'])) {
                     $exclude_tax = explode(',', $form_options['search_in_post_type_categories_exclude_tax']);
                     if ($exclude_tax) {
                        $post_type_taxonomies = array_filter($post_type_taxonomies, function ($tax) use ($exclude_tax) {
                           return !in_array($tax, $exclude_tax);
                        });
                     }
                  }

                  $terms = get_terms([
                     'taxonomy'     => $post_type_taxonomies,
                     'hide_empty'   => (int) $form_options['search_in_post_type_categories_hide_empty'],
                     'number'       => (int) $form_options['search_in_post_type_categories_limit'],
                     'name__like'   => $keyword
                  ]);

                  if (!empty($terms)) {
                     ob_start();
                     echo '<div class="box-heading"><div class="bh-right"><div class="bh-text">' . $form_options['search_in_post_type_categories_title'] . '</div></div><div class="bh-left"></div></div>';

                     foreach ($terms as $term) {
                        include wfs_PP . '/templates/ajax-terms-result.php';
                     }
                     $result['terms_search_results'] = ob_get_clean();
                  }
               }
            }
         }

         $query = new WP_Query($args);

         $has_result = 0;

         if ($query->have_posts()) {
            $has_result = 1;
            $result['has_result'] = 1;

            ob_start();
            include wfs_PP . '/templates/ajax-result.php';
            $result['html'] = ob_get_clean();

            $result['user_last_search'] = [];

            while ($query->have_posts()) {
               $query->the_post();

               $result['user_last_search'][] = [
                  'id'           => get_the_ID(),
                  'title'        => get_the_title(),
                  'title_limit'  => wac_content_limit(get_the_title(), isset($form_options['search_result_title_limit']) && is_numeric($form_options['search_result_title_limit']) ? (int) $form_options['search_result_title_limit'] : 40),
                  'thumbnail'    => wfs_get_thumbnail_src(get_the_ID(), 'woocommerce_thumbnail', 1),
                  'link'         => esc_url(get_the_permalink()),
               ];
            }

            if ($form_options['search_autocomplete']) {
               if ($form_options['search_autocomplete_by'] == 'keywords') {
                  $search_autocomplete = WFS_DB_Queries::get_related_searches((int) $_POST['form_id'], (string) $keyword, 1);
                  if (!empty($search_autocomplete)) {
                     $search_autocomplete = reset($search_autocomplete);
                     $result['search_autocomplete'] = $search_autocomplete->text;
                  }
               } elseif ($form_options['search_autocomplete_by'] == 'posts') {
                  if (!empty($result['user_last_search'])) {
                     $search_autocomplete = reset($result['user_last_search']);
                     $result['search_autocomplete'] = $search_autocomplete['title'];
                  }
               }
            }

            wp_reset_postdata();
         } else {
            $result['user_last_search'] = [];
            $result['html'] = '<div class="search-no-result">' . wfs_get_form_translate($form_options, 'no_result') . '</div>';
         }

         if (!empty($keyword)) {
            $tracking_code = WFS_DB_Queries::insert_search_log($keyword, $_POST['form_id'], $has_result);

            $keyword_id = WFS_DB_Queries::insert_search_keyword($keyword, $_POST['form_id'], $has_result);
            WFS_DB_Queries::insert_search_keyword_daily($_POST['form_id'], $keyword_id);

            $result['tracking_code'] = $tracking_code;
         }

         echo wp_json_encode($result);
         exit();
      }

      public function ajax_load_search_related()
      {
         if (!wp_verify_nonce($_POST['nonce'], 'wfs-ajax-nonce')) {
            exit;
         }

         if (!isset($_POST['keyword']) || (isset($_POST['keyword']) && empty($_POST['keyword']))) {
            exit;
         }

         if (!isset($_POST['form_id']) || !is_numeric($_POST['form_id'])) {
            exit;
         }

         if (!isset($_POST['post_type']) || empty($_POST['post_type'])) {
            exit;
         }

         if (!isset($_POST['form_action']) || empty($_POST['form_action'])) {
            exit;
         }

         if (!isset($_POST['search_query_var']) || empty($_POST['search_query_var'])) {
            exit;
         }

         if (!isset($_POST['post_type_query_var']) || empty($_POST['post_type_query_var'])) {
            exit;
         }

         $keyword = esc_attr(sanitize_text_field(wfs_convert_arabic_string_to_persian($_POST['keyword'])));
         $keyword = trim($keyword);

         $related_limit = 5;

         if (isset($_POST['related_limit']) && is_numeric($_POST['related_limit'])) {
            $related_limit = (int) $_POST['related_limit'];
         }

         include wfs_PP . '/templates/ajax-related-result.php';

         exit();
      }

      public function ajax_clear_user_searches()
      {
         header('Content-Type: application/json; charset=utf-8');

         if (!wp_verify_nonce($_POST['nonce'], 'wfs-ajax-nonce')) {
            echo json_encode([
               'status' => 'error',
            ]);
            exit;
         }

         if (!get_current_user_id()) {
            echo json_encode([
               'status' => 'error',
            ]);
            exit;
         }

         echo json_encode([
            'status' => 'ok',
         ]);

         exit();
      }

      public function ajax_getting_terms()
      {
         header('Content-Type: application/json; charset=utf-8');

         if (!wp_verify_nonce($_POST['nonce'], 'wfs-ajax-nonce')) {
            echo wp_json_encode([
               'status' => 'error',
               'terms' => []
            ]);
            exit;
         }

         if (!isset($_POST['search']) || empty($_POST['search'])) {
            echo wp_json_encode([
               'status' => 'error',
               'terms' => []
            ]);
            exit;
         }

         $taxonomies = [];

         if (!empty($_POST['post_types'])) {
            $post_types_arr = explode(',', $_POST['post_types']);

            foreach ($post_types_arr as $post_type) {
               $post_type_taxonomies_check = get_taxonomies([
                  'object_type' => [$post_type]
               ], 'objects');

               if (!empty($post_type_taxonomies_check)) {
                  $taxonomies = array_merge($taxonomies, $post_type_taxonomies_check);
               }
            }
         }

         $categories = new \WP_Term_Query([
            'taxonomy'     => array_keys($taxonomies),
            'hide_empty'   => 0,
            'number'       => 0,
            'name__like'   => wfs_convert_arabic_string_to_persian($_POST['search'])
         ]);

         $categories_new = [];

         if (count($categories->get_terms())) {
            foreach (array_values($categories->get_terms()) as $cat) {
               $tax_name = get_taxonomy($cat->taxonomy)->labels->name;
               $categories_new[] = [
                  'id' => $cat->term_id,
                  'text' => $cat->name . ' (' . $tax_name . ')',
               ];
            }
         }

         echo wp_json_encode([
            'status' => 'ok',
            'terms' => $categories_new
         ]);
         exit();
      }
   }
   WFS_Ajax::ins();
}
