function wfs_debounce(func, timeout = 300) {
   let timer;
   return (...args) => {
      clearTimeout(timer);
      timer = setTimeout(() => { func.apply(this, args); }, timeout);
   };
}

function wfs_get_uls_html(carousel_class, wrapper_class, form_id, form_action, form_post_type, search_query_var, post_type_query_var) {
   var wfs_uls = localStorage.getItem('wfs_lus');

   var wfs_uls_pare = JSON.parse(wfs_uls);

   if (wfs_uls_pare != null && wfs_uls_pare.length) {
      var wfs_uls_html = '';

      jQuery.each(wfs_uls_pare.reverse(), function (ind, val) {
         wfs_uls_html += '<div class="box-item">';

         wfs_uls_html += '<a title="' + val.keyword + '" href="' + form_action + '?' + search_query_var + '=' + val.keyword.replace(' ', '+');

         wfs_uls_html += '&' + post_type_query_var + '=' + form_post_type;

         wfs_uls_html += '&form_id=' + form_id;

         wfs_uls_html += '">';

         wfs_uls_html += '<span>' + val.keyword + '</span>';

         wfs_uls_html += '<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M15 18l-6-6 6-6" /></svg>';

         wfs_uls_html += '</a>';

         wfs_uls_html += '</div>';
      });

      jQuery(carousel_class).html(wfs_uls_html),
         jQuery(carousel_class).owlCarousel({
            items: 5,
            margin: 10,
            responsiveClass: true,
            nav: 1,
            dots: 0,
            autoplay: 0,
            loop: 0,
            autoWidth: 1,
            rtl: wfs_ajax_var.is_rtl ? true : false,
         }),
         jQuery(wrapper_class).css('display', 'block');
   }
}

function wfs_save_user_last_search_result(data) {
   if (typeof data.results !== 'undefined' && data.results.length === 0) {
      localStorage.removeItem('wfs_ulsr');
   }
   else {
      localStorage.setItem('wfs_ulsr', JSON.stringify(data));
   }
}

function wfs_clear_uls() {
   jQuery('.wfs-uls-wrapper').css('display', 'none');
   localStorage.removeItem('wfs_lus');
}

function wfs_close_toggle_tooltip(el) {
   localStorage.setItem('wfs_close_toggle_tooltip', 1);
   jQuery(el).hide();
}

function wfs_render_toggle_tooltip(el) {
   var closed = localStorage.getItem('wfs_close_toggle_tooltip');

   if (closed) {
      jQuery(el).hide();
   }
}

jQuery(document).ready(function ($) {
   if (wfs_ajax_var.search_query != undefined) {
      if (
         (wfs_ajax_var.search_query.is_search != undefined && wfs_ajax_var.search_query.is_search == true) &&
         (wfs_ajax_var.search_query.keyword != undefined && wfs_ajax_var.search_query.keyword != '')
      ) {
         var wfs_uls = localStorage.getItem('wfs_lus');

         if (wfs_uls === null) {
            var wfs_uls = [];

            wfs_uls.push({
               keyword: wfs_ajax_var.search_query.keyword,
               count: 1
            });

            localStorage.setItem('wfs_lus', JSON.stringify(wfs_uls));
         }
         else {
            var wfs_uls_parse = JSON.parse(wfs_uls);

            if (wfs_uls_parse.length) {
               const hasKeyword = wfs_uls_parse.findIndex(e => e.keyword === wfs_ajax_var.search_query.keyword);

               if (hasKeyword === -1) {
                  wfs_uls_parse.push({
                     keyword: wfs_ajax_var.search_query.keyword,
                     count: 1
                  });
               }
               else {
                  wfs_uls_parse[hasKeyword].count++;
                  var old_obj = wfs_uls_parse[hasKeyword];
                  wfs_uls_parse.splice(hasKeyword, 1);
                  wfs_uls_parse.push(old_obj);
               }

               localStorage.setItem('wfs_lus', JSON.stringify(wfs_uls_parse));
            }
         }
      }
   }
});