function wfs_media_upload(self, target, type = ['image']) {
   custom_uploader = wp.media.frames.file_frame = wp.media({
      library: {
         type: type
      },
      multiple: false
   });

   custom_uploader.on('select', function () {
      attachment = custom_uploader.state().get('selection').first().toJSON();
      jQuery(target).val(attachment.id);
      jQuery(target + '_preview').css('display', 'block');
      jQuery(target + '_preview img').attr('src', attachment.url);
      jQuery(target + '_clear').css('display', 'block');
      return;
   });

   custom_uploader.open(self);

   return;
}

function wfs_media_clear(target) {
   jQuery(target).val('');
   jQuery(target + '_preview').css('display', 'none');
   jQuery(target + '_preview img').attr('src', '');
   jQuery(target + '_clear').css('display', 'none');
}

function wfs_visibility_layout_controls(self) {
   if (jQuery(self).val() == 'popup') {
      jQuery('#layout_popup_controls').css('display', 'block');
   }
   else {
      jQuery('#layout_popup_controls').css('display', 'none');
   }
}

function wfs_visibility_layout_popup_button_controls(self) {
   if (jQuery(self).val() == 'none') {
      jQuery('#layout_popup_action_button_controls').css('display', 'none');
   }
   else {
      jQuery('#layout_popup_action_button_controls').css('display', 'block');
   }
}

jQuery(document).ready(function ($) {
   $('#search_result_post_types').select2({
      width: '100%',
      dir: wfs_vars.is_rtl ? 'rtl' : 'ltr',
      dropdownAutoWidth: true,
   });

   $('#search_in_post_type_categories_exclude_tax').select2({
      width: '100%',
      dir: wfs_vars.is_rtl ? 'rtl' : 'ltr',
      dropdownAutoWidth: true,
   });

   $('#style_overlay_color').wpColorPicker();
   $('#style_form_icon_color').wpColorPicker();
   $('#style_form_text_color').wpColorPicker();
   $('#style_form_background_color').wpColorPicker();
   $('#style_form_border_color').wpColorPicker();
   $('#style_search_form_post_type_select_text_color').wpColorPicker();
   $('#style_search_form_post_type_select_background_color').wpColorPicker();
   $('#style_search_form_post_type_select_border_color').wpColorPicker();
   $('#style_result_box_background_color').wpColorPicker();
   $('#style_result_box_border_color').wpColorPicker();
   $('#style_related_result_icon_color').wpColorPicker();
   $('#style_related_result_link_color').wpColorPicker();
   $('#style_related_result_link_hover_color').wpColorPicker();
   $('#style_related_result_border_color').wpColorPicker();
   $('#style_user_last_searches_icon_color').wpColorPicker();
   $('#style_user_last_searches_heading_color').wpColorPicker();
   $('#style_user_last_searches_item_link_color').wpColorPicker();
   $('#style_user_last_searches_item_link_hover_color').wpColorPicker();
   $('#style_user_last_searches_item_link_arrow_color').wpColorPicker();
   $('#style_user_last_searches_item_link_arrow_hover_color').wpColorPicker();
   $('#style_papular_searches_icon_color').wpColorPicker();
   $('#style_papular_searches_heading_color').wpColorPicker();
   $('#style_papular_searches_item_link_color').wpColorPicker();
   $('#style_papular_searches_item_link_hover_color').wpColorPicker();
   $('#style_papular_searches_item_link_arrow_color').wpColorPicker();
   $('#style_papular_searches_item_link_arrow_hover_color').wpColorPicker();
   $('#style_suggested_categories_icon_color').wpColorPicker();
   $('#style_suggested_categories_heading_color').wpColorPicker();
   $('#style_suggested_categories_item_link_color').wpColorPicker();
   $('#style_suggested_categories_item_link_hover_color').wpColorPicker();
   $('#style_suggested_categories_item_link_arrow_color').wpColorPicker();
   $('#style_suggested_categories_item_link_arrow_hover_color').wpColorPicker();
   $('#style_search_result_item_icon_color').wpColorPicker();
   $('#style_search_result_item_link_color').wpColorPicker();
   $('#style_search_result_item_link_hover_color').wpColorPicker();
   $('#post_type_product_results_price_color').wpColorPicker();
   $('#style_sr_ci_background').wpColorPicker();
   $('#style_sr_ci_border_color').wpColorPicker();
   $('#layout_popup_action_button_text_color').wpColorPicker();
   $('#layout_popup_action_button_background_color').wpColorPicker();
});