<?php

/**
 * Plugin Name: Webafra: Core Plugin
 * Description: Webafra core and common func
 * Author: Webafra
 * Author URI: https://webafra.com/
 * Version: 0.0.4
 * Text Domain: webafra-core
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.2
 */

define('WAC_PF', plugin_dir_url(__FILE__));
define('WAC_PP', plugin_dir_path(__FILE__));

add_action('init', function () {
   load_plugin_textdomain('webafra-core', false, dirname(plugin_basename(__FILE__)) . '/languages');
});

include_once WAC_PP . '/includes/functions.php';
include_once WAC_PP . '/includes/class-core.php';

if (!function_exists('jdate')) {
   include_once WAC_PP . '/includes/calendars/jdf.php';
}

include_once WAC_PP . '/includes/calendars/islamic-calendar.php';

add_action('admin_enqueue_scripts',  function ($hook) {
   $version = time();
   wp_enqueue_script('jquery');

   wp_enqueue_script('wp-color-picker');
   wp_enqueue_style('wp-color-picker');

   wp_register_script('wac-color-picker-alpha', WAC_PF . 'assets/js/wp-color-picker-alpha.min.js', ['wp-color-picker'], $version, false);
   wp_enqueue_script('wac-color-picker-alpha');

   wp_enqueue_style('wac-select2', WAC_PF . 'assets/select2/select2.min.css', [], $version);
   wp_enqueue_script('wac-select2', WAC_PF . 'assets/select2/select2.min.js', ['jquery'], $version, false);

   wp_enqueue_style('wac-jquery.calendars.picker', WAC_PF . 'assets/jquery.calendars/jquery.calendars.picker.css', [], $version);
   wp_enqueue_script('wac-jquery.plugin.min', WAC_PF . 'assets/jquery.calendars/jquery.plugin.min.js', ['jquery'], $version, false);
   wp_enqueue_script('wac-jquery.calendars.min', WAC_PF . 'assets/jquery.calendars/jquery.calendars.min.js', ['jquery'], $version, false);
   wp_enqueue_script('wac-jquery.calendars.plus.min', WAC_PF . 'assets/jquery.calendars/jquery.calendars.plus.min.js', ['jquery'], $version, false);
   wp_enqueue_script('wac-calendars.picker.min', WAC_PF . 'assets/jquery.calendars/jquery.calendars.picker.min.js', ['jquery'], $version, false);
   wp_enqueue_script('wac-calendars.islamic.min', WAC_PF . 'assets/jquery.calendars/jquery.calendars.islamic.min.js', ['jquery'], $version, false);

   wp_enqueue_style('wac-jalalidatepicker.min', WAC_PF . 'assets/jalalidatepicker/jalalidatepicker.min.css', [], $version);
   wp_enqueue_script('wac-jalalidatepicker.min', WAC_PF . 'assets/jalalidatepicker/jalalidatepicker.min.js', ['jquery'], $version, false);

   wp_enqueue_script('wac-admin', WAC_PF . 'assets/js/admin.js', ['jquery'], $version, false);
   wp_enqueue_style('wac-common', WAC_PF . '/assets/css/common.css', [], $version);
   wp_enqueue_style('wac-admin', WAC_PF . '/assets/css/admin.css', [], $version);
});

add_action('wp_enqueue_scripts',  function ($hook) {
   $version = time();
   wp_enqueue_style('wac-common', WAC_PF . '/assets/css/common.css', [], $version);
   wp_enqueue_style('wac-front', WAC_PF . '/assets/css/front.css', [], $version);
});

$GLOBALS['Webafra_Core'] = Webafra_Core::ins();

function webafra_core()
{
   return $GLOBALS['Webafra_Core'];
}
