<?php
if (!defined('ABSPATH')) {
   die;
}

if (!function_exists('wac_form_responsive_control')) {
   function wac_form_responsive_control(string $id)
   {
      include WAC_PP . '/templates/form-responsive-control.php';
   }
}

if (!function_exists('wac_form_responsive_input_number')) {
   function wac_form_responsive_input_number($form, string $id, array $items = [], string $min = '', string $max = '', $dir = 'ltr')
   {
      $responsive = [
         'desktop'   => __('Desktop', 'webafra-core'),
         'tablet'    => __('Tablet', 'webafra-core'),
         'mobile'    => __('Mobile', 'webafra-core'),
      ];

      if (!empty($items)) {
         foreach ($responsive as $device => $placeholder) {
            $item_id = $device == 'desktop' ? $id : "{$id}_{$device}";
            $style   = $device == 'desktop' ? 'block' : 'none';
            echo '<div id="' . $item_id . '" style="display:' . $style . '; direction:' . $dir . ';">';
            foreach ($items as $item_key => $item) {
               $item_id = $device == 'desktop' ? "{$id}_{$item_key}" : "{$id}_{$item_key}_{$device}";
               echo '<input class="wac-form-responsive-input-number" name="' . $item_id . '" type="number" value="' . $form->form_options[$item_id] . '" placeholder="' . $item . '" min="' . $min . '" max="' . $max . '">';
            }
            echo '</div>';
         }
      } else {
         foreach ($responsive as $device => $placeholder) {
            $item_id = $device == 'desktop' ? $id : "{$id}_{$device}";
            $style   = $device == 'desktop' ? 'block' : 'none';
            echo '<div id="' . $item_id . '" style="display:' . $style . '; direction:' . $dir . ';">';
            echo '<input class="wac-form-responsive-input-number" name="' . $item_id . '" type="number" value="' . $form->form_options[$item_id] . '" placeholder="' . $placeholder . '" min="' . $min . '" max="' . $max . '" style="width:150px!important;min-width:150px!important;">';
            echo '</div>';
         }
      }
   }
}

if (!function_exists('wac_generate_random_str')) {
   /**
    * Generate random string.
    * 
    * @param int $length
    * 
    * @return string
    */
   function wac_generate_random_str($length = 25, array $chars = ['num', 'low', 'up']): string
   {
      $characters = '';

      if (in_array('num', $chars)) {
         $characters .= '0123456789';
      }

      if (in_array('low', $chars)) {
         $characters .= 'abcdefghijklmnopqrstuvwxyz';
      }

      if (in_array('up', $chars)) {
         $characters .= 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
      }

      $charactersLength = strlen($characters);
      $randomString = '';
      for ($i = 0; $i < $length; $i++) {
         $randomString .= $characters[rand(0, $charactersLength - 1)];
      }
      return $randomString;
   }
}

if (!function_exists('wac_content_limit')) {
   /**
    * Limit string length.
    * 
    */
   function wac_content_limit($content, $limit = 10, $strip_tags = false)
   {
      if ($strip_tags) {
         $content = preg_replace('|[[\/\!]*?[^\[\]]*?]|si', '', $content);
         $content = str_replace("\n", ' ', $content);
         $content = strip_tags($content);
      }

      return mb_strlen($content) > $limit ? mb_substr($content, 0, $limit - 1) . '...' : $content;
   }
}

if (!function_exists('wac_date')) {
   function wac_date($date, string $calendar = 'shamsi_calendar', string $format = 'Y/m/d H:i')
   {
      $date = strtotime($date, current_time('timestamp'));
      $new_date = date($format, $date);

      if ($calendar == 'shamsi_calendar') {
         if (function_exists('jdate')) {
            $new_date = jdate($format, $date, '', 'UTC');
         }
      }

      if ($calendar == 'hijri_calendar') {
         if (class_exists('uCal2')) {
            $hijri = new uCal2();
            $hijri->setLang('ar');
            $new_date = $hijri->date($format, $date);
         }
      }

      return $new_date;
   }
}

if (!function_exists('wac_get_post_types')) {
   function wac_get_post_types()
   {
      $post_types = [];

      $post_types = (array) get_post_types(['public' => true], 'objects');

      if (!empty($post_types)) {
         $post_types = array_filter($post_types, function ($post_type) {
            $to_unset = [
               'e-landing-page',
               'elementor_library',
               'attachment'
            ];

            return !in_array($post_type->name, $to_unset);
         });
      }

      return $post_types;
   }
}

if (!function_exists('wac_pagination')) {
   function wac_pagination(int $total_pages, $active_page = 1)
   {
      if (isset($_GET['paged']) && is_numeric($_GET['paged'])) {
         $active_page = $_GET['paged'];
      }

      $pagBtn              = "<ul class='wac-pagination'>";
      $minus_page          = $active_page - 2;
      $plus_page           = $active_page + 3;

      if ($minus_page < 1 || $active_page == 1) {
         $minus_page = 1;
      }

      if ($active_page > 3) {
         $pagBtn .= "<li class='page-item' data-page_no='1'><a href='" . $_SERVER['REQUEST_URI'] . "&paged=1'>1</a></li>";
      }

      if (($minus_page - 1) > 1) {
         $pagBtn .= "...";
      }

      $last_page = 0;

      for ($i = $minus_page; $i < $plus_page; $i++) {
         if ($i < $total_pages) {
            $is_active  = $active_page == $i ? ' active' : '';
            $pagBtn     .= "<li class='page-item" . $is_active . "' data-page_no='" . $i . "'><a class='" . $is_active . "' href='" . $_SERVER['REQUEST_URI'] . "&paged=" . $i . "'>" . $i . "</a></li>";
            $last_page  = $i;
         }
      }

      if (($total_pages - $last_page) > 1) {
         $pagBtn .= "...";
      }

      if ($total_pages > $last_page) {
         $is_active  = $active_page == $total_pages ? ' active' : '';
         $pagBtn     .= "<li class='page-item" . $is_active . "' data-page_no='" . $total_pages . "'><a class='" . $is_active . "' href='" . $_SERVER['REQUEST_URI'] . "&paged=" . $total_pages . "'>" . $total_pages . "</a></li>";
      }

      echo $pagBtn . "</ul>";
   }
}
