<?php
if (!defined('ABSPATH')) {
   die;
}

class Webafra_Core
{
   public static $ins = null;

   public static function ins()
   {
      if (is_null(self::$ins)) {
         self::$ins = new self();
      }

      return self::$ins;
   }

   public function __construct()
   {
      add_filter('cron_schedules', [$this, 'cron_schedules']);
   }

   public function cron_schedules($schedules)
   {
      if (!isset($schedules['wac_1min'])) {
         $schedules['wac_1min'] = [
            'interval'  => 60,
            'display'   => __('Once every 1 minute')
         ];
      }

      if (!isset($schedules['wac_2min'])) {
         $schedules['wac_2min'] = [
            'interval'  => 2 * 60,
            'display'   => __('Once every 2 minutes')
         ];
      }

      if (!isset($schedules['wac_5min'])) {
         $schedules['wac_5min'] = [
            'interval'  => 5 * 60,
            'display'   => __('Once every 5 minutes')
         ];
      }

      if (!isset($schedules['wac_30min'])) {
         $schedules['wac_30min'] = [
            'interval'  => 30 * 60,
            'display'   => __('Once every 30 minutes')
         ];
      }

      if (!isset($schedules['wac_1year'])) {
         $schedules['wac_1year'] = [
            'interval'  => 60, //31536000,
            'display'   => __('Once every year')
         ];
      }

      return $schedules;
   }
}
