function wac_register_range_datepicker(calendar, locale, el_start, el_end) {
   if (locale == 'fa_IR') {
      var isRTL = true;
   }
   else {
      var isRTL = false;
   }

   var start_val = jQuery(el_start).val();
   var end_val = jQuery(el_end).val();

   if (calendar == 'shamsi_calendar') {
      jalaliDatepicker.startWatch({
         zIndex: 999999,
         separatorChars: {
            date: '-'
         }
      });
   }
   else if (calendar == 'hijri_calendar') {
      jQuery.calendars.calendars.islamic.prototype.regionalOptions.ar = {
         name: 'Islamic',
         epochs: ['BAM', 'AM'],
         monthNames: 'محرم_صفر_ربيع الأول_ربيع الثاني_جمادى الأول_جمادى الآخر_رجب_شعبان_رمضان_شوال_ذو القعدة_ذو الحجة'.split('_'),
         monthNamesShort: 'محرم_صفر_ربيع1_ربيع2_جمادى1_جمادى2_رجب_شعبان_رمضان_شوال_القعدة_الحجة'.split('_'),
         dayNames: ['الأحد', 'الإثنين', 'الثلاثاء', 'الأربعاء', 'الخميس', 'الجمعة', 'السبت'],
         dayNamesShort: 'أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت'.split('_'),
         dayNamesMin: 'ح_ن_ث_ر_خ_ج_س'.split('_'),
         digits: jQuery.calendars.substituteDigits(['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩']),
         dateFormat: 'yyyy-mm-dd',
         firstDay: 1,
         isRTL: true
      };

      jQuery(el_start).calendarsPicker({
         calendar: jQuery.calendars.instance('islamic', 'ar'),
         isRTL: true,
         todayText: 'اليوم',
         prevText: '< سابق',
         nextText: 'التالي >',
         clearText: 'واضح',
         clearStatus: 'امسح كل التواريخ',
         closeText: 'يغلق',
         closeStatus: 'أغلق منتقي البيانات',
      });

      jQuery(el_end).calendarsPicker({
         calendar: jQuery.calendars.instance('islamic', 'ar'),
         isRTL: true,
         todayText: 'اليوم',
         prevText: '< سابق',
         nextText: 'التالي >',
         clearText: 'واضح',
         clearStatus: 'امسح كل التواريخ',
         closeText: 'يغلق',
         closeStatus: 'أغلق منتقي البيانات',
      });
   }
   else {
      if (start_val != '') {
         var start_val_new = new Date(start_val);
      }
      else {
         var start_val_new = '';
      }

      if (end_val != '') {
         end_val_new = new Date(end_val);
      }
      else {
         end_val_new = '';
      }

      jQuery(el_start).datepicker({
         dateFormat: 'yy-mm-dd',
         defaultDate: start_val_new,
         isRTL: isRTL,
         changeMonth: true,
      });

      jQuery(el_end).datepicker({
         dateFormat: 'yy-mm-dd',
         defaultDate: end_val_new,
         isRTL: isRTL,
         changeMonth: true,
      });
   }
}

function wac_change_css_displaying(element, display = 'flex') {
   jQuery(element).css('display', display);
}

function wac_group_collapse(self, icon, element) {
   jQuery(self).toggleClass('close');
   jQuery(icon).toggleClass('close');
   jQuery(element).toggleClass('open');
}

function wac_visibility_toggle(toggle, element) {
   if (toggle.checked) {
      jQuery(element).css('display', 'block');
   } else {
      jQuery(element).css('display', 'none');
   }
}

function wac_tables_check_all(toggle, count) {
   if (toggle.checked) {
      for (var i = 0, n = count; i < n; i++) {
         jQuery('#bulk_items_checkbox_' + i).prop('checked', true);
      }
   } else {
      for (var i = 0, n = count; i < n; i++) {
         jQuery('#bulk_items_checkbox_' + i).prop('checked', false);
      }
   }
}

function wac_form_styling_by_device(action, el_control, el_desktop, el_tablet, el_mobile) {
   if (action == 'desktop') {
      jQuery(el_control + ' #desktop svg').css('stroke', 'blue');
      jQuery(el_control + ' #tablet svg').css('stroke', 'black');
      jQuery(el_control + ' #mobile svg').css('stroke', 'black');

      jQuery(el_desktop).css('display', 'block');
      jQuery(el_tablet).css('display', 'none');
      jQuery(el_mobile).css('display', 'none');
   }
   else if (action == 'tablet') {
      jQuery(el_control + ' #desktop svg').css('stroke', 'black');
      jQuery(el_control + ' #tablet svg').css('stroke', 'blue');
      jQuery(el_control + ' #mobile svg').css('stroke', 'black');

      jQuery(el_desktop).css('display', 'none');
      jQuery(el_tablet).css('display', 'block');
      jQuery(el_mobile).css('display', 'none');
   }
   else if (action == 'mobile') {
      jQuery(el_control + ' #desktop svg').css('stroke', 'black');
      jQuery(el_control + ' #tablet svg').css('stroke', 'black');
      jQuery(el_control + ' #mobile svg').css('stroke', 'blue');

      jQuery(el_desktop).css('display', 'none');
      jQuery(el_tablet).css('display', 'none');
      jQuery(el_mobile).css('display', 'block');
   }
}